#include "xmltraversal.h"
#include <QRegExp>
#include <QVariant>


XMLTraversal::iterator::iterator() {
}

XMLTraversal::iterator::iterator(const QDomNode& n): elt_(n) {
  cur_ = elt_.firstChild() ;
}

XMLTraversal::iterator::iterator(const XMLTraversal::iterator& i): 
  elt_(i.elt_), cur_(i.cur_) 
{
}

XMLTraversal::iterator::iterator(const QDomNode& n, const QDomNode& c):
  elt_(n), cur_(c)
{
}

XMLTraversal::iterator XMLTraversal::iterator::operator ++() {
  if (!cur_.isNull())
    cur_ = cur_.nextSibling() ;
  return XMLTraversal::iterator(*this) ;
}

XMLTraversal::iterator XMLTraversal::iterator::operator ++(int) {
  if (cur_.isNull())
    return XMLTraversal::iterator(*this) ;
  
  QDomNode cur = cur_ ;
  cur_ = cur_.nextSibling() ;
  return XMLTraversal::iterator(elt_, cur) ;
}


// -------------------------------------------------------------------------

XMLTraversal::XMLTraversal() {
  cur_path_node_ = doc_ ;
  markUpdated();
}

XMLTraversal::XMLTraversal(QByteArray s)
{
  doc_ = QDomDocument() ;
  doc_.setContent(s) ;
  cur_path_node_ = doc_ ;
  markUpdated();
}


XMLTraversal::XMLTraversal(QString s)
{
  doc_ = QDomDocument() ;
  doc_.setContent(s) ;
  cur_path_node_ = doc_ ;
  markUpdated();
}

XMLTraversal::XMLTraversal(QDomDocument doc) {
  doc_ = doc ;
  cur_path_node_ = doc_ ;
  markUpdated();
}

bool XMLTraversal::setDocument(QString s) {
  doc_.clear();
  doc_ = QDomDocument() ;
  bool ok = doc_.setContent(s) ;
  cur_path_node_ = doc_ ;
  clearStack();	
  markUpdated();
  return ok ;
}

bool XMLTraversal::setDocument(QByteArray s) {
  doc_.clear();
  doc_ = QDomDocument() ;
  bool ok = doc_.setContent(s) ;
  cur_path_node_ = doc_ ;
  clearStack();
  markUpdated();
  return ok ;
}



bool XMLTraversal::setDocument(QDomDocument doc) {
  doc_.clear();
  doc_ = doc ;
  cur_path_node_ = doc_ ;
  clearStack();	
  markUpdated();
  return !doc_.isNull() ;
}

QDomNode XMLTraversal::cd_to_node(const QString& path)
{
   // GDS << "Enter " << path << endl;
  if (path.isEmpty() ) {
    cur_path_node_ = doc_ ;
    return cur_path_node_ ;
  }

  if (path[0]=='/')
    cur_path_node_ = doc_ ;

  QDomNode node = cur_path_node_ ;
  QStringList toks = path.split("/",QString::SkipEmptyParts);
  //GDS << "Token Count " << toks.count() << endl;
  for (int i=0; i<toks.size(); i++)
  {
    //GDS << " i " << i << " token " << toks[i] << endl;
    if(toks[i].isEmpty())
    {
        // skip
    }
    else if (toks[i]=="..")
    {
      node = node.parentNode() ;
      if (node.isNull()) return QDomNode() ;
    }
    else if (toks[i]=="...")
    { // an alias to  cd ../..
      node = node.parentNode() ;
      if (node.isNull()) 	return QDomNode() ;
      node = node.parentNode() ;
      if (node.isNull()) 	return QDomNode() ;
    }
    else
    {
        node = node.namedItem(toks[i]) ;
        if (node.isNull()) return QDomNode();
        //GDS << node << endl;
    };
  }

  return node ;
}

bool XMLTraversal::cd(const QString& path) {
  if(!path.isEmpty())
  {			

	QDomNode node = cd_to_node(path) ;
	if (node.isNull())
	return false ;
	cur_path_node_ = node ;
  };	
  return true ;
}

bool XMLTraversal::cd(const QDomElement& e) {
  // TODO: THIS IMPLEMENTATION IS A BULLSHIT!!!!
  // We did that to avoid this kind of problem if
  // we have folder at same sibling with same name!!
  QDomNode n = cur_path_node_.firstChild() ;
  for(; !n.isNull(); n = n.nextSibling()) {
    QDomElement ne = n.toElement() ;
    if (ne==e) {
      cur_path_node_ = n ;
      return true ;
    }
  }
    
  return false ;
}

//
// set the text node for the current node
  void XMLTraversal::setText(QString s)
  {
      markUpdated();
      if(cur_path_node_.isElement())
      {
          // remove any existing text nodes
          QDomNode n = cur_path_node_.firstChild() ;
          for(; !n.isNull(); n = n.nextSibling())
          {
              if(n.isText())
              {
                  cur_path_node_.removeChild(n);
                  break;
              };
          };
        QDomText t =   doc_.createTextNode(s);
        cur_path_node_.appendChild(t);
       };
  };

QString XMLTraversal::pwd() const {
  if (cur_path_node_==doc_)
    return "/" ;

  QString path ;
  QDomNode node = cur_path_node_ ;
  while(!node.isDocument()) {
    path = node.nodeName()+"/"+path ;
    node = node.parentNode() ;
  }
  return "/" + path ;
}

QStringList XMLTraversal::ls() const {
  QStringList list ;
  QDomNode node = cur_path_node_.firstChild() ;
  while(!node.isNull()) {
    if (node.isElement())
      list.append(node.toElement().tagName()) ;
    node = node.nextSibling() ;
  }
  return list ;
}

QDomElement XMLTraversal::mkdir(const QString& d)
{
    DBG("d = " << d);
    if(d.isEmpty())  return currentElement() ;
  QDomNode n;
  if(d[0] == '/')
   {
        // start from root
      DBG("Set path to root");
        n = document();
  }
  else
  {
      // start from current node
      DBG("Use current ");
      n = currentNode();
  };
  if(!n.isNull())
  {
    // create any missing directories
      QStringList toks = d.split("/",QString::SkipEmptyParts) ;
      for (int i=0; i<toks.size(); i++)
      {
          QDomNode nxt =  n.namedItem(toks[i]);
          if(nxt.isNull())
          {
              DBG("Create dir " << toks[i]);
                QDomElement e = doc_.createElement(toks[i]) ;
                nxt = n.appendChild(e) ;
          }
           n = nxt;
      }
}
  markUpdated();
  return n.toElement();
}

QDomNode XMLTraversal::currentNode(const QString& path) const {
  if (path.isEmpty())  return cur_path_node_ ;
	
  XMLTraversal* This = const_cast<XMLTraversal*>(this) ;
  QDomNode node = cur_path_node_ ;
  if (!This->cd(path))
    return QDomNode() ; // invalid
  QDomNode e = cur_path_node_ ;
  This->cur_path_node_ = node ;
  return e ;
}

bool XMLTraversal::setAttribute(const QString& path,
				const QString& attrname,
                const QString& attrvalue)
{
  QDomNode node = currentNode(path) ;
  if (!node.isElement() || node.isNull())
    return false ;
  node.toElement().setAttribute(attrname, attrvalue) ;
  markUpdated();
  return true ;
}

bool XMLTraversal::setAttribute(const QString& attrname,
                const QString& attrvalue)
{
  QDomNode node = currentNode() ;
  if (!node.isElement() || node.isNull())
    return false ;
  node.toElement().setAttribute(attrname, attrvalue) ;
  markUpdated();
  return true ;
}

bool XMLTraversal::rmdir(const QString& d) {
  QDomNode cur = cur_path_node_ ;
  QDomNode node = cd_to_node(d) ;
  cur_path_node_ = cur ;

  if (node.isNull())
    return false ;

  QDomNode parent = node.parentNode() ;
  if (parent.isNull())
    return false ;

  node = parent.removeChild(node) ;
  if (node.isNull())
    return false ;
  markUpdated();
  return true ;
}

// Possible configurations:
// ========================
//  mv /toto/titi/trululu tralala  (rename)
//  mv /toto/titi/trululu /toto/titi/tralala  (rename because same parent)
//  mv /toto/titi/trululu /tsointsoin  (move because parent differents)
bool XMLTraversal::mv(const QString& oldpath, const QString& newpath) {
  QDomNode cur = cur_path_node_ ;
  markUpdated();

  if (newpath.isNull() || newpath.isEmpty())
    return false ;

  QDomNode oldnode = cd_to_node(oldpath) ;
  cur_path_node_ = cur ;
  if (oldnode.isNull())
    return false ;

  QDomNode newnode = cd_to_node(newpath) ;
  cur_path_node_ = cur ;
  // Maybe a move command
  if (!newnode.isNull() && oldnode!=newnode) {
    if (!oldnode.parentNode().isNull()) {
      oldnode = oldnode.parentNode().removeChild(oldnode) ;
      newnode.appendChild(oldnode) ;
      return true ;
    }
    return false ;
  }

  // Or a rename command
  if (!oldnode.isElement()) // because rename the tag
    return false ;

  if (newnode.isNull()) {
    QString path ;
    QStringList toks = newpath.split("/",QString::SkipEmptyParts) ;
    if (toks.size()>1) {
      // assert that the parent is valid
      for (int i=0; i<toks.size()-1; i++) {
	if (i==0 && newpath[0]!='/')
	  path += toks[i] ;
	else
	  path += "/" + toks[i] ;
      }
      QDomNode parent = cd_to_node(path) ;
      cur_path_node_ = cur ;
      if (parent.isNull())
	return false ; // no valid parent

      oldnode.toElement().setTagName(toks.last()) ;
      return true ;
    } 
    else {
      oldnode.toElement().setTagName(toks.first()) ;
      return true ;
    }
  }

  return false ;
}

bool XMLTraversal::cp(const QString& source, const QString& target) {
  QDomNode cur = cur_path_node_ ;

  if (source.isNull() || source.isEmpty())
    return false ;
  if (target.isNull() || target.isEmpty())
    return false ;

  QDomNode sourcenode = cd_to_node(source) ;
  cur_path_node_ = cur ;
  if (sourcenode.isNull())
    return false ;

  QDomNode targetnode = cd_to_node(target) ;
  cur_path_node_ = cur ;
  if (targetnode.isNull())
    return false ;
	
  // Check that the target node is not a child of source
  QDomNode node = targetnode ;
  while(!node.isNull()) {
    if (node==sourcenode)
      return false ;
    node = node.parentNode() ;
  }

  // Ok, copy and move it
  targetnode.appendChild(sourcenode.cloneNode()) ;
  markUpdated();
  return true ;
 }


QVariant XMLTraversal::elementToVariant(QDomElement e)
{
        QVariant res;
        QVariant::Type t = QVariant::nameToType ( e.attribute("Type").toAscii());
        switch(t)
        {
                case QVariant::List:
                {
                    QStringList l = ls(); // get the item listing
                    QVariantList lv;
                    for(int i = 0;i < l.count(); i++)
                    {
                        QVariant v;
                         XmlGet(l[i],v);
                         lv << v;
                    };
                    res.setValue(lv);
                };
                 break;
                case QVariant::Map:
                {
                    QVariantMap m;
                    QStringList l = ls();
                    for(int i = 0; i < l.count(); i++)
                    {
                        QVariant v;
                        XmlGet(l[i],v);
                        m[l[i]] = v;
                    };
                   res = QVariant(m);
                };
                break;
                case QVariant::StringList:
                {
                    QStringList l = ls();
                    QStringList lv;
                    for(int i = 0;i < l.count(); i++)
                    {
                        QVariant v;
                         XmlGet(l[i],v);
                         lv << v.toString();
                    };
                    res.setValue(lv);
                };
                break;
                default:
                        // get the text node
                       // GDS << "text = " << e.text() << endl;
                        res = QVariant(e.text());
                        res.convert(t); // cast as necessary
                        break;
        };
        return res;
};

void XMLTraversal::VariantToElement(QVariant v , QDomElement e)
{
        e.setAttribute("Type",QVariant::typeToName(v.type()));
        // remove children - catch is that values all have to be terminal directories
        if(e.hasChildNodes())
        {
            QDomNode n = e.firstChild();
            while(!n.isNull())
            {
              QDomNode nx = n.nextSibling();
              e.removeChild(n);
              n = nx;
            };
        };
        switch(v.type())
        {
                case QVariant::List:
                {
                    QVariantList l = v.toList();
                    for(int i = 0;i < l.count(); i++)
                    {
                           XmlSet(QString("Item%1").arg(i),l[i]);
                    };
                };
                 break;
                case QVariant::Map: // store the map
                {
                        QVariantMap mx = v.toMap();
                        QMap<QString,QVariant>::iterator j =  mx.begin();
                        for(;j != mx.end(); ++j)
                        {
                            XmlSet(j.key(),j.value());
                        };
                };
                break;
                case QVariant::StringList: // store the list
                {
                    QStringList l = v.toStringList();
                    for(int i = 0;i < l.count(); i++)
                     {
                           XmlSet(QString("Item%1").arg(i),l[i]);
                    }
                };
                break;
                default:
                {
                    QDomText t = e.ownerDocument().createTextNode(v.toString());
                    e.appendChild(t);
                };
                break;
        };
};



