#ifndef TRACE_HPP
#define TRACE_HPP
/*!
 * \file trace.hpp
 *  Tracing macros and routines
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */
#include <QTextStream>
#include <QtDebug>
#include <QTime>
#include <QBuffer>
//
#include "Utility_global.h"
//
/**
* @brief  Debug time tracking class
*
* @class DbgTime trace.hpp "trace.hpp"
*/
class UTILITYSHARED_EXPORT DbgTime
{
  public:
    static QTime Ticks;
    /**
    * @brief  Constructs and starts the timer
    *
    * @fn DbgTime
    */
    DbgTime() { Ticks.start();}
    /**
    * @brief returns the number of milliseconds since starting
    *
    * @fn ticks
    */
    static long ticks() { return Ticks.elapsed();}
    /**
    * @brief  restarts the timer from zero
    *
    * @fn restart
    *
    */
    static void restart() { Ticks.restart();}
};

inline QString byteArrayToString(QByteArray b)
{
    QBuffer bf;
    bf.open(QIODevice::WriteOnly);
    QTextStream os(&bf);
    os << hex;
    for(int i = 0; i < b.size(); i++)
    {
        os << (unsigned char)b.at(i) << (!(i % 32)?"\n":" ");
    }
    bf.close();
    return bf.buffer();
}

//
// trace from within a function
// Debug Trace
//
#define STRINGIFY(x) #x
#define TOSTRING(x) STRINGIFY(x)
#define AT __FILE__ ":" TOSTRING(__LINE__)
#define FILELINE(reason)  AT  reason
//
#define GDS qDebug() << "[" << DbgTime::ticks() << "] "FILELINE(":")
//
#ifdef DEBUGON
#define DBG(s) GDS << s;
#else
/**
    @brief Debug macro that includes, timestamp, file , function and line number
    DEBUGON must be defined to enable trace output
    @code
    DBG("Example Trace Message Item = " << Item)
    @endcode
    @fn DBG
  */
#define DBG(s)
#endif


// function entry and exit
/**
  @brief  Function Entry
  @fn DBG_IN
*/
#define DBG_IN DBG("Enter")
/**
  @brief  Function Entry
  @fn DBG_OUT
*/

#define DBG_OUT DBG("Exit")
// trace point
#define TRC DBG("Trace");

#endif
	
