#ifndef TaskStates_H
#define TaskStates_H
#include "TaskCore_global.h"
#include <Utility/base.hpp>
//
// these are the default states
#define TASK_NONE "None"
#define TASK_WAITING "Waiting"
#define TASK_OK "Ok"
#define TASK_DISABLED "Disabled"
#define TASK_FAULT "Fault"

// message levels - these are also alarm levels plus the above
#define TASK_TRACE "TraceLevel"
#define TASK_DEBUG "DebugLevel"
#define TASK_INFO "InfoLevel"
#define TASK_WARNING "WarningLevel"
#define TASK_ERROR "ErrorLevel"
#define TASK_CRITICAL "CriticalLevel"
#define TASK_FATAL "FatalLevel"
#define TASK_WRITE "WriteLevel"
//
// the standard alarm threshold types
//
#define TASK_HIHI "HiHi"
#define TASK_HILO "HiLo"
#define TASK_LOHI "LoHi"
#define TASK_LOLO "LoLo"
//
class StatisticsThresholdSet;
//
#ifdef QT_GUI_LIB
#include <QStandardItem>
#include <QListWidgetItem>

class TASKCORESHARED_EXPORT   TaskStates
{
	// state name
	QString name;
	// the image
        QIcon icon;
	// the level
	unsigned level;
	// name to show as - this can be translated
	QString displayName;
	// colours
	QColor  foreground;
	QColor background;

	public:
                TaskStates(QString n = "", QIcon  i = QPixmap(), unsigned  l = 0, QString d = "",
			QColor f = Qt::black, QColor b = Qt::white)
			: name(n),icon(i),level(l),displayName(d) ,foreground(f),background(b)
			{}
		TaskStates(const TaskStates &a)
			: name(a.name),icon(a.icon),level(a.level),displayName(a.displayName),
			foreground(a.foreground),background(a.background)
			{}

// accessors
                QIcon getIcon() const  { return icon;}
		QString getName() const { return name;}
		unsigned getLevel() const {return level;}
		QString getDisplayName() { return QObject::tr(displayName.toAscii());}
		QColor getForeground() const { return foreground;}
		QColor getBackground() const { return background;}
//
                void setIcon(QIcon i){icon = i;}
		void setLevel(unsigned i) { level = i;}
		void setDisplayName(QString i) { displayName = i;}
		void setForeground(QColor i) { foreground = i;}
		void setbackground(QColor i) { background = i;}
//
		typedef QMap<QString,TaskStates> MAP;
//
	// the state map
		static MAP States;
		static MAP & getStates() {return States;}
		static void initialiseStates();
		static bool loadStates(QString s);
		static bool saveStates(QString s);

                static void setStandardItemToState(QString s, QStandardItem *i)
                {
                    i->setIcon(getStates()[s].getIcon());
                    i->setText(getStates()[s].getDisplayName());
                    setStandardItemToIconColours(s,i);
                }

                static void setStandardItemToIconColours(QString s, QStandardItem *i)
                {
                    i->setIcon(getStates()[s].getIcon());
                    i->setData(getStates()[s].getForeground(),Qt::ForegroundRole);
                    i->setData(getStates()[s].getBackground(),Qt::BackgroundRole);
                }

                static void setStandardItemToColours(QString s, QStandardItem *i)
                {
                    i->setData(getStates()[s].getForeground(),Qt::ForegroundRole);
                    i->setData(getStates()[s].getBackground(),Qt::BackgroundRole);
                }



                static void setListWidgetItemToColours(QString s, QListWidgetItem *i)
                {
                    i->setBackground(getStates()[s].getBackground());
                    i->setForeground(getStates()[s].getForeground());
                    i->setIcon(getStates()[s].getIcon());
                }

                static void setTableWidgetItemToColours(QString s, QTableWidgetItem *i)
                {
                    i->setBackground(getStates()[s].getBackground());
                    i->setForeground(getStates()[s].getForeground());
                    i->setIcon(getStates()[s].getIcon());
                }


             //
};
#endif

QString StatisticStateToState(StatisticsThresholdSet &st);

// TaskStates_H
#endif
