#include "taskstates.h"
#include <Utility/xmltraversal.h>
#include <Utility/stats.hpp>
	// the state map
TaskStates::MAP TaskStates::States;

//
// set up default set
//
void TaskStates::initialiseStates()
{
	States.clear();
        States[TASK_NONE] =  TaskStates(TASK_NONE, QIcon(":/TaskCore/Inactive.png"), 0, QObject::tr("None"));
        States[TASK_WAITING] =  TaskStates(TASK_WAITING, QIcon(":/TaskCore/Waiting.png"),1,QObject::tr("Waiting"));
        States[TASK_DISABLED] =  TaskStates(TASK_DISABLED, QIcon(":/TaskCore/Disabled.png"), 2, QObject::tr("Disabled")
		,Qt::black,Qt::gray);
        States[TASK_FAULT] =  TaskStates(TASK_FAULT, QIcon(":/TaskCore/Fault.png"),
		1000, QObject::tr("Fault"),Qt::red,Qt::black);
        States[TASK_OK] =  TaskStates(TASK_OK, QIcon(":/TaskCore/Ok.png"),
                100, QObject::tr("Ok"), Qt::black,Qt::green);
    // Log levels
        States[TASK_TRACE] =  TaskStates(TASK_TRACE, QIcon(":/TaskCore/LogIcons/"TASK_TRACE".png"),0,
                                         QObject::tr("Trace"), Qt::black,Qt::gray);
        States[TASK_DEBUG] =  TaskStates(TASK_DEBUG, QIcon(":/TaskCore/LogIcons/"TASK_DEBUG".png"),0,
                                         QObject::tr("Debug"), Qt::red,Qt::gray);
        States[TASK_INFO] =  TaskStates(TASK_INFO, QIcon(":/TaskCore/LogIcons/"TASK_INFO".png"),0,
                                        QObject::tr("Information"), Qt::yellow,Qt::blue);
        States[TASK_WARNING] =  TaskStates(TASK_WARNING, QIcon(":/TaskCore/LogIcons/"TASK_WARNING".png"),200,
                                         QObject::tr("Warning"), Qt::black,Qt::yellow);
        States[TASK_ERROR] =  TaskStates(TASK_ERROR, QIcon(":/TaskCore/LogIcons/"TASK_ERROR".png"),300,
                                         QObject::tr("Error"), Qt::black,Qt::red);
        States[TASK_CRITICAL] =  TaskStates(TASK_CRITICAL, QIcon(":/TaskCore/LogIcons/"TASK_CRITICAL".png"),500,
                                         QObject::tr("Critical"), Qt::white,Qt::darkMagenta);
        States[TASK_FATAL] =  TaskStates(TASK_FATAL, QIcon(":/TaskCore/LogIcons/"TASK_FATAL".png"),600,
                                         QObject::tr("Fatal"), Qt::white,Qt::darkBlue);
        States[TASK_WRITE] =  TaskStates(TASK_WRITE, QIcon(":/TaskCore/LogIcons/"TASK_WRITE".png"),0,
                                         QObject::tr("Write"), Qt::black,Qt::white);
//
// define the alarm threshold colour scheme
//
 States[TASK_HIHI] =  TaskStates(TASK_HIHI, QIcon(":/TaskCore/Alarm.png"),300,
                                                      QObject::tr("High Alarm"), Qt::black,Qt::red);
States[TASK_LOLO] =  TaskStates(TASK_LOLO, QIcon(":/TaskCore/Alarm.png"),300,
                                QObject::tr("Low Alarm"), Qt::black,Qt::red);
States[TASK_HILO] =  TaskStates(TASK_HILO, QIcon(":/TaskCore/Warning.png"),200,
                                 QObject::tr("High Warning"), Qt::black,Qt::yellow);
States[TASK_LOHI] =  TaskStates(TASK_LOHI, QIcon(":/TaskCore/Warning.png"),200,
                                 QObject::tr("Low Warning"), Qt::black,Qt::yellow);

}


bool TaskStates::loadStates(QString s)
{
// load a states file
	XMLTraversal x;
	// file generated by state editor
	if(x.loadFromFile(s))
	{
		x.cd("/States");
		QStringList l = x.ls();
	// clear and add base set
		initialiseStates();
		for(int i = 0; i < l.count(); i++)
		{
			x.push();
			if(x.cd(l[i]))
			{
				int Priority;
				QString Icon;
				QString DisplayName;
//
				Priority = x.GetVar("Priority").toInt();
				Icon =  x.GetVar("Icon").toString();
				DisplayName = x.GetVar("DisplayName").toString();
//
				QColor f(x.GetVar("Foreground").toString());
				QColor b(x.GetVar("Background").toString());
                                States[l[i]] =  TaskStates(l[i], QIcon(QString(":/States/%1").arg(Icon)), Priority, QObject::tr(DisplayName.toAscii()), f,b);

			}
			x.pop();
		}
	}
	return false;
}


// translate  from statistics state to state name
QString StatisticStateToState(StatisticsThresholdSet &st)
{
    QString res = TASK_OK;
     if(st.triggered())
     {
         switch(st.maxState())
         {
            case StatisticsThreshold::HiHi:
             {
                 res = TASK_HIHI;
             }
             break;
             case StatisticsThreshold::HiLo:
             {
                 res = TASK_HILO;
             }
             break;
             case StatisticsThreshold::LoHi:
             {
                 res = TASK_LOHI;
             }
             break;
             case StatisticsThreshold::LoLo:
             {
                 res = TASK_LOLO;
             }
             break;
         default:
             break;
         }
     }
     return res;
}

