#ifndef Status_HPP
#define Status_HPP


//$Id$
//(c) B. J. Hill 2007-
//
// this encapuslates element status values
// status values have a name and priority (value)
// this is an extensible list - but  really do not expect more than one or two extra
// status types to be created
// hence the default steps of 16  in priority
//

#include "base.hpp"

class   UTILITYSHARED_EXPORT  Status
{
	  // translation maps
		static QMap<QString,unsigned> statusValueMap;
		static QMap<unsigned,QString> valueStatusMap;
		// current value
		unsigned value;
	public:
		static void addStatus(QString s, unsigned v)
		{
			statusValueMap[s] = v;
			valueStatusMap[v] = s;
                }
		static void removeStatus(QString s)
		{
			unsigned v = statusValueMap[s];
			statusValueMap.remove(s);
			valueStatusMap.remove(v);
                }

                static void removeStatus(unsigned v)
		{
			QString s = valueStatusMap[v];
			statusValueMap.remove(s);
			valueStatusMap.remove(v);
                }
		static unsigned toValue(QString s)
		{
			return statusValueMap[s];
                }
		static QString toString(unsigned v)
		{
			if(!valueStatusMap.contains(v)) return QString("Undefined");
			return valueStatusMap[v];
                }
                Status(unsigned v = 0): value(v) {}
                Status(const QString s) : value(statusValueMap[s]) {}
                Status(const Status &s) : value(s.value){}
                unsigned getValue() const { return value;}
                void setValue(unsigned v) { value = v;}
                QString getName() const { return toString(value);}
		//
		
};

inline QDataStream & operator >> (QDataStream &is, Status &s)
{
	unsigned v;
	is >> v;
	s.setValue(v);
	return is;
};

inline QDataStream &  operator << (QDataStream &os, const Status &s)
{
	os << s.getValue();
	return os;
};
#endif
