#ifndef States_H
#define States_H
#include <Utility/base.hpp>
//
// these are the default states
#define STATES_NONE "None"
#define STATES_WAITING "Waiting"
#define STATES_OK "Ok"
#define STATES_DISABLED "Disabled"
#define STATES_FAULT "Fault"

// message levels - these are also alarm levels plus the above
#define STATES_TRACE "TraceLevel"
#define STATES_DEBUG "DebugLevel"
#define STATES_INFO "InfoLevel"
#define STATES_WARNING "WarningLevel"
#define STATES_ERROR "ErrorLevel"
#define STATES_CRITICAL "CriticalLevel"
#define STATES_FATAL "FatalLevel"
#define STATES_WRITE "WriteLevel"
//
// the standard alarm threshold types
//
#define STATES_HIHI "HiHi"
#define STATES_HILO "HiLo"
#define STATES_LOHI "LoHi"
#define STATES_LOLO "LoLo"
//
class StatisticsThresholdSet;
//
#ifdef QT_GUI_LIB
#include <QStandardItem>
#include <QListWidgetItem>

class   UTILITYSHARED_EXPORT    States
{
	// state name
	QString name;
	// the image
        QIcon icon;
	// the level
	unsigned level;
	// name to show as - this can be translated
	QString displayName;
	// colours
	QColor  foreground;
	QColor background;

	public:
                States(QString n = "", QIcon  i = QPixmap(), unsigned  l = 0, QString d = "",
			QColor f = Qt::black, QColor b = Qt::white)
			: name(n),icon(i),level(l),displayName(d) ,foreground(f),background(b)
			{}
                States(const States &a)
			: name(a.name),icon(a.icon),level(a.level),displayName(a.displayName),
			foreground(a.foreground),background(a.background)
			{}

// accessors
                QIcon getIcon() const  { return icon;}
		QString getName() const { return name;}
		unsigned getLevel() const {return level;}
		QString getDisplayName() { return QObject::tr(displayName.toAscii());}
		QColor getForeground() const { return foreground;}
		QColor getBackground() const { return background;}
//
                void setIcon(QIcon i){icon = i;}
		void setLevel(unsigned i) { level = i;}
		void setDisplayName(QString i) { displayName = i;}
		void setForeground(QColor i) { foreground = i;}
		void setbackground(QColor i) { background = i;}
//
                typedef QMap<QString,States> MAP;
//
	// the state map
                static MAP _States;
                static MAP & getStates() {return _States;}
		static void initialiseStates();
		static bool loadStates(QString s);
		static bool saveStates(QString s);

                static void setStandardItemToState(QString s, QStandardItem *i)
                {
                    i->setIcon(getStates()[s].getIcon());
                    i->setText(getStates()[s].getDisplayName());
                    setStandardItemToIconColours(s,i);
                }

                static void setStandardItemToIconColours(QString s, QStandardItem *i)
                {
                    i->setIcon(getStates()[s].getIcon());
                    i->setData(getStates()[s].getForeground(),Qt::ForegroundRole);
                    i->setData(getStates()[s].getBackground(),Qt::BackgroundRole);
                }

                static void setStandardItemToColours(QString s, QStandardItem *i)
                {
                    i->setData(getStates()[s].getForeground(),Qt::ForegroundRole);
                    i->setData(getStates()[s].getBackground(),Qt::BackgroundRole);
                }



                static void setListWidgetItemToColours(QString s, QListWidgetItem *i)
                {
                    i->setBackground(getStates()[s].getBackground());
                    i->setForeground(getStates()[s].getForeground());
                    i->setIcon(getStates()[s].getIcon());
                }

                static void setTableWidgetItemToColours(QString s, QTableWidgetItem *i)
                {
                    i->setBackground(getStates()[s].getBackground());
                    i->setForeground(getStates()[s].getForeground());
                    i->setIcon(getStates()[s].getIcon());
                }


             //
};
#endif

QString StatisticStateToState(StatisticsThresholdSet &st);

// States_H
#endif
