#include "states.h"
#include <Utility/xmltraversal.h>
#include <Utility/stats.hpp>
	// the state map
States::MAP States::_States;
//
// set up default set
//
void States::initialiseStates()
{
        _States.clear();
        _States[STATES_NONE] =  States(STATES_NONE, QIcon(":/Utility/Icon/Inactive.png"), 0, QObject::tr("None"));
        _States[STATES_WAITING] =  States(STATES_WAITING, QIcon(":/Utility/Icon/Waiting.png"),1,QObject::tr("Waiting"));
        _States[STATES_DISABLED] =  States(STATES_DISABLED, QIcon(":/Utility/Icon/Disabled.png"), 2, QObject::tr("Disabled")
		,Qt::black,Qt::gray);
        _States[STATES_FAULT] =  States(STATES_FAULT, QIcon(":/Utility/Icon/Fault.png"),
		1000, QObject::tr("Fault"),Qt::red,Qt::black);
        _States[STATES_OK] =  States(STATES_OK, QIcon(":/Utility/Icon/Ok.png"),
                100, QObject::tr("Ok"), Qt::black,Qt::green);
    // Log levels
        _States[STATES_TRACE] =  States(STATES_TRACE, QIcon(":/Utility/Icon/LogIcons/"STATES_TRACE".png"),0,
                                         QObject::tr("Trace"), Qt::black,Qt::gray);
        _States[STATES_DEBUG] =  States(STATES_DEBUG, QIcon(":/Utility/Icon/LogIcons/"STATES_DEBUG".png"),0,
                                         QObject::tr("Debug"), Qt::red,Qt::gray);
        _States[STATES_INFO] =  States(STATES_INFO, QIcon(":/Utility/Icon/LogIcons/"STATES_INFO".png"),0,
                                        QObject::tr("Information"), Qt::yellow,Qt::blue);
        _States[STATES_WARNING] =  States(STATES_WARNING, QIcon(":/Utility/Icon/LogIcons/"STATES_WARNING".png"),200,
                                         QObject::tr("Warning"), Qt::black,Qt::yellow);
        _States[STATES_ERROR] =  States(STATES_ERROR, QIcon(":/Utility/Icon/LogIcons/"STATES_ERROR".png"),300,
                                         QObject::tr("Error"), Qt::black,Qt::red);
        _States[STATES_CRITICAL] =  States(STATES_CRITICAL, QIcon(":/Utility/Icon/LogIcons/"STATES_CRITICAL".png"),500,
                                         QObject::tr("Critical"), Qt::white,Qt::darkMagenta);
        _States[STATES_FATAL] =  States(STATES_FATAL, QIcon(":/Utility/Icon/LogIcons/"STATES_FATAL".png"),600,
                                         QObject::tr("Fatal"), Qt::white,Qt::darkBlue);
        _States[STATES_WRITE] =  States(STATES_WRITE, QIcon(":/Utility/Icon/LogIcons/"STATES_WRITE".png"),0,
                                         QObject::tr("Write"), Qt::black,Qt::white);
//
// define the alarm threshold colour scheme
//
_States[STATES_HIHI] =  States(STATES_HIHI, QIcon(":/Utility/Icon/Alarm.png"),300,
                                                      QObject::tr("High Alarm"), Qt::black,Qt::red);
_States[STATES_LOLO] =  States(STATES_LOLO, QIcon(":/Utility/Icon/Alarm.png"),300,
                                QObject::tr("Low Alarm"), Qt::black,Qt::red);
_States[STATES_HILO] =  States(STATES_HILO, QIcon(":/Utility/Icon/Warning.png"),200,
                                 QObject::tr("High Warning"), Qt::black,Qt::yellow);
_States[STATES_LOHI] =  States(STATES_LOHI, QIcon(":/Utility/Icon/Warning.png"),200,
                                 QObject::tr("Low Warning"), Qt::black,Qt::yellow);

}


bool States::loadStates(QString s)
{
// load a states file
	XMLTraversal x;
	// file generated by state editor
	if(x.loadFromFile(s))
	{
		x.cd("/States");
		QStringList l = x.ls();
	// clear and add base set
		initialiseStates();
		for(int i = 0; i < l.count(); i++)
		{
			x.push();
			if(x.cd(l[i]))
			{
				int Priority;
				QString Icon;
				QString DisplayName;
//
				Priority = x.GetVar("Priority").toInt();
				Icon =  x.GetVar("Icon").toString();
				DisplayName = x.GetVar("DisplayName").toString();
//
				QColor f(x.GetVar("Foreground").toString());
				QColor b(x.GetVar("Background").toString());
                                _States[l[i]] =  States(l[i], QIcon(QString(":/States/%1").arg(Icon)), Priority, QObject::tr(DisplayName.toAscii()), f,b);

			}
			x.pop();
		}
	}
	return false;
}


// translate  from statistics state to state name
QString StatisticStateToState(StatisticsThresholdSet &st)
{
    QString res = STATES_OK;
     if(st.triggered())
     {
         switch(st.maxState())
         {
            case StatisticsThreshold::HiHi:
             {
                 res = STATES_HIHI;
             }
             break;
             case StatisticsThreshold::HiLo:
             {
                 res = STATES_HILO;
             }
             break;
             case StatisticsThreshold::LoHi:
             {
                 res = STATES_LOHI;
             }
             break;
             case StatisticsThreshold::LoLo:
             {
                 res = STATES_LOLO;
             }
             break;
         default:
             break;
         }
     }
     return res;
}

