#ifndef SNSSPREAD_H
#define SNSSPREAD_H
/*!
 * \file snsspread.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */
#include <base.hpp>
#include <sp.h>

/**
 * Timeout is a simple wrapper around Sptread::sp_time the %Spread C
 * API's Spread::sp_time struct that facilitates specifying connection
 * timeouts for the Mailbox constructor.  The constructor will convert
 * an integral number into a Timeout instance, allowing you to specify
 * timeouts to the Mailbox constructor as either Timeout instances or
 * a single number (interpreted as a number of seconds).
 */
class  UTILITYSHARED_EXPORT Timeout {
  sp_time time;

public:
  /**
   * Converts a Spread::sp_time instance to a Timeout instance, copying
   * the stored time representation in the process.
   *
   * @param time The Spread::sp_time instance to convert.
   */
  Timeout(const sp_time time) : time(time) { }

  /**
   * Creates a Timeout instance representing a number of seconds
   * plus microseconds.  The constructor also is able to convert
   * an int or long to a Timeout, interpreting the number as the
   * first constructor argument (the number of seconds).
   *
   * @param sec The number of seconds.
   * @param usec The number of microseconds.
   */
  Timeout(const long sec = 0, const long usec = 0) {
    time.sec = sec, time.usec = usec;
  }

  /**
   * Converts a Timeout instance to a Spread::sp_time instance.
   *
   * @return A Spread::sp_time value representing the same time value.
   */
  operator sp_time() const { return time; }
  bool isZero() { return !(time.sec || time.usec);}
};


/**
 * @brief Wrapper for SP_ functions. Refere to the Spread documentation for full details
 *
*/
class UTILITYSHARED_EXPORT SnsSpread : public QObject
{
    Q_OBJECT
    mailbox _mailbox; // mailbox - connect handle
    QByteArray _privateName;
    int _num_groups;
public:

    /**
     * @brief This class encapsulates a spread message
     *
    */
    class Message
    {
         service _service_type;
         QString _sender;
         short int _mess_type;
         int _endian_mismatch;
         QByteArray _data;
    public:
         /**
          * @brief
          *
          * @param st
          * @param s
          * @param mt
          * @param em
          * @param d
          * @return
         */
         Message(service st = 0, QString s = "", short int mt = 0, int em = 0, QByteArray d = QByteArray()) :
                 _service_type(st),_sender(s),_mess_type(mt),_endian_mismatch(em),_data(d){}
         /**
          * @brief Copy constructor
          *
          * @param m
          *
         */
         Message(const Message &m) :
                 _service_type(m._service_type),
                 _sender(m._sender),
                 _mess_type(m._mess_type),
                 _endian_mismatch(m._endian_mismatch),
                 _data(m._data){}

         // accessors
         /**
          * @brief
          *
          * @return service
         */
         service service_type() const
         { return _service_type;}
         /**
          * @brief
          *
          * @return QString
         */
         QString sender() const
         { return _sender;}
         /**
          * @brief
          *
          * @return short
         */
         short int mess_type() const
         { return _mess_type;}
         /**
          * @brief
          *
          * @return int
         */
         int endian_mismatch() const
         { return _endian_mismatch;}
         QByteArray data() const
         { return _data;}
         //
         /**
          * @brief
          *
          * @param s
         */
         void setService_type(service s)
         { _service_type = s;}
         void setSender(QString s)
         { _sender = s;}
         /**
          * @brief
          *
          * @param m
         */
         void setMess_type(short int m)
         {  _mess_type = m;}
         /**
          * @brief
          *
          * @param f
         */
         void setEndian_mismatch(int f)
         {_endian_mismatch = f;}
         /**
          * @brief
          *
          * @param d
         */
         void setData(QByteArray d)
         { _data = d;}
         //
        friend class SnsSpread;
    };

    explicit SnsSpread(QObject *parent = 0);
    ~SnsSpread();

    mailbox getMailbox() const { return _mailbox;}
    /**
     * @brief Tests to see if connection is valid
     *
     * @return True if connected (_mailbox is non-zero)
    */
    bool isConnected() const { return _mailbox != 0;}
    /**
     * @brief
     *
     * @return QByteArray
    */
    QByteArray privateName()
    { return _privateName;}
    // Spread SP_ function wrappers
    int connectTo(QString spread_host, int spread_port = 4803, QString private_name = QString(), int priority = 0, bool group_membership = true, Timeout timeOut = Timeout());
    int disconnectFrom();
    int join(QString);
    int leave(QString);
    int multicast(service service_type, QString group, int mess_type, QByteArray b);
    int receive(Message &m, QStringList &groupList);
    int equalGroupIds(group_id g1, group_id g2);
    int poll();
    void error(int);
    void kill();
};

#endif // SNSSPREAD_H
