#include <QCoreApplication>
#include <QDebug>

#include "QtSystemInfo.h"

QString systemTypeToString(QtSystemInfo::SystemType type)
{
    switch (type)
    {
    case QtSystemInfo::UnknownType:
        return "UnknownType";
    case QtSystemInfo::UnknownUnix:
        return "UnknownUnix";
    case QtSystemInfo::MacOSX:
        return "MacOSX";
    case QtSystemInfo::Windows:
        return "Windows";
    case QtSystemInfo::WindowsCE:
        return "WindowsCE";
    case QtSystemInfo::Linux:
        return "Linux";
    case QtSystemInfo::UnknownBSD:
        return "UnknownBSD";
    case QtSystemInfo::FreeBSD:
        return "FreeBSD";
    case QtSystemInfo::OpenBSD:
        return "OpenBSD";
    case QtSystemInfo::NetBSD:
        return "NetBSD";
    }

    return "Bad input value!";
}

QString architectureToString(QtSystemInfo::ArchitectureType type)
{
    switch (type)
    {
    case QtSystemInfo::UnknownArchitectureType:
        return "UnknownArchitectureType";
    case QtSystemInfo::I386:
        return "I386";
    case QtSystemInfo::I486:
        return "I486";
    case QtSystemInfo::I586:
        return "I586";
    case QtSystemInfo::I686:
        return "I686";
    case QtSystemInfo::X86_64:
        return "X86_64";
    case QtSystemInfo::PPC:
        return "PPC";
    case QtSystemInfo::PPC64:
        return "PPC64";
    }

    return "Bad input value!";
}

int main(int argc, char *argv[])
{
    QCoreApplication app(argc, argv);

    QtSystemInfo systemInfo(&app);

    qDebug() << "System name:      " << qPrintable(systemInfo.systemName());
    qDebug() << "System version:   " << qPrintable(systemInfo.systemVersion());
    qDebug() << "Kernel name:      " << qPrintable(systemInfo.kernelName());
    qDebug() << "Kernel version:   " << qPrintable(systemInfo.kernelVersion());
    qDebug() << "Architecture name:" << qPrintable(systemInfo.architectureName());
    qDebug() << "System type:      " << qPrintable(systemTypeToString(systemInfo.systemType()));
    qDebug() << "Architecture type:" << qPrintable(architectureToString(systemInfo.architecture()));

#ifdef Q_OS_WIN
    return app.exec();
#else
    return 0;
#endif
}
