#ifndef FILE_H
#define FILE_H
/*!
 * \file file.h
 *
 * \author B. J. Hill
 * \date
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */
#include "base.hpp"
#include "Utility_global.h"

// file names rooted on the applications file system
/**
* @brief  This class provides QFile object with reference to the root directory.
*
* @class File file.h "file.h"
*/
class UTILITYSHARED_EXPORT File : public QFile
{
    static QString _root; // root of file name
public:
    /**
    * @brief  Constructs the File object
    *
    * @fn File
    * @param dir   Directory
    * @param  nm  stem of file name
    * @param ext   extention for file name
    */
    File(QString dir, QString nm = "", QString ext = "")
    {
        QString s = QString("%1/%2").arg(_root).arg(dir);
        if(!nm.isEmpty()) {s += "/" ;  s += nm;}
        if(!ext.isEmpty()) s += ext;
        setFileName(s);
    };
    /**
    * @brief  Returns the root file path
    *
    * @fn root
    */
    static QString root() { return _root;}
    /**
    * @brief  Sets the root file path
    *
    * @fn setRoot
    * @param s
    */
    static void setRoot(QString s) { _root = s;}
};

#endif // FILE_H
