#ifndef ActionLimits_HPP
#define ActionLimits_HPP
//$Id$
//(c) B. J. Hill 2007-
//action limits class
// any action that is level triggered
//
#include "stats.hpp"
#include "status.hpp"
#include "base.hpp"
class UTILITYSHARED_EXPORT ActionLimits : public QObject
{
	Q_OBJECT
	//
public:
        enum TriggerDirType {LowToHigh, HighToLow};
private:

        bool Triggered; // true if triggered
        bool NotifyTriggerOn; // true if signal emitted when triggered
        bool NotifyTriggerOff; // true if signal emitted when exiting triggered state
        TriggerDirType TriggerType; // trigger direction
        QDateTime TriggerOnTime; // when the triggered was on
        QDateTime TriggerOffTime; // when the trigger was off
        QDateTime UpdateTime; // the last update time
        bool StatisticalActions; // true if actions are statitical
        unsigned ActionWindow; // the size of the action window
        unsigned ActionOnCount; // the number of triggers within the action window to signal triggered
        QString StatusName; // the name of the status that is triggered
        //
	Statistics statistics; // stats since last trigger state change
        unsigned long triggerBuffer; // bit list of triggers
        unsigned triggerCount; // number of triggers
        unsigned triggerWindow;
        Status ActionStatus; //the current action status
	//
        double Level; // the trigger threshold
	public:

                ActionLimits(QObject *p, QString n) : QObject(p),Triggered(false),
                NotifyTriggerOn(false),NotifyTriggerOff(false),TriggerType(LowToHigh),StatisticalActions(false),
                triggerBuffer(0),triggerCount(0),triggerWindow(0),Level(0)
		{
                    setObjectName(n);
                }
        bool getTriggered() const { return Triggered;}
        void setTriggered(bool f) { Triggered = f;}
        double getLevel() const { return Level;}
        void setLevel(double v) { Level = v;}
        bool getNotifyTriggerOn() const { return NotifyTriggerOn;}
        void setNotifyTriggerOn(bool f) { NotifyTriggerOn = f;}
        bool getNotifyTriggerOff() const { return NotifyTriggerOff;}
        void setNotifyTriggerOff(bool f) { NotifyTriggerOff = f;}
        TriggerDirType getTriggerType() const { return TriggerType;}
        void setTriggerType(TriggerDirType d) {TriggerType = d;}
	//
        QDateTime getTriggerOnTime() const { return TriggerOnTime;}
        void setTriggerOnTime(QDateTime t) { TriggerOnTime = t;}
        QDateTime getTriggerOffTime() const { return TriggerOffTime;}
        void setTriggerOffTime(QDateTime t) { TriggerOffTime = t;}
	//
        QDateTime getUpdateTime() const { return UpdateTime;}
        void setUpdateTime(QDateTime t) { UpdateTime = t;}
        Statistics & getStatistics() { return statistics;}
	//
        bool getStatisticalActions() const {return StatisticalActions;}
        void setStatisticalActions(bool s) { StatisticalActions = s;}
	//
//
public:
        unsigned getActionWindow() const {return ActionWindow;}
        void setActionWindow(unsigned s) { ActionWindow = s;}
//
public:
        unsigned getActionOnCount() const {return ActionOnCount;}
        void setActionOnCount(unsigned s) { ActionOnCount = s;}
//
public:
Status getActionStatus() const {return ActionStatus;}
void setActionStatus(Status s) { ActionStatus = s;}
//
//
public:
QString getStatusName() const {return StatusName;}
void setStatusName(QString s) { StatusName = s;}
//
//	
//
public slots:
	// set the next value - test the limits and set the state
	void setValue(double v);

signals:
	void TriggerOn(QString); 
	void TriggerOff(QString);
	void StatusChange(unsigned);


public slots:
        void clear()
        {
                statistics.clear();
                triggerBuffer = 0;
                triggerCount = 0;
                if(Triggered && NotifyTriggerOff)
                {
                    emit TriggerOff(objectName());
                }
                Triggered = false;
                setActionStatus(0);
        }

};

#endif
