//$Id$
//(c) B. J. Hill 2007-
//

#include "actionlimits.hpp"

//
//Function: ActionLimits::setValue
//Purpose:
//Inputs:
//Outputs:
//Returns:
//

void ActionLimits::setValue(double v)
{
	bool fireOn = false;
	bool fireOff = false;
	bool fire = false;
	QDateTime t = QDateTime::currentDateTime();
	if(TriggerType == LowToHigh)
	{
		if(v >= Level)
		{
			fire = true;
		};
	}
	else if(TriggerType == HighToLow)
	{
		if(v <= Level)
		{
			fire = true;
		};
	};
	//
        if(getStatisticalActions())
	{
		// limit buffer to 31 events
		if(triggerBuffer & 1)
		{
			if(triggerCount > 0) triggerCount--;
		};
		triggerBuffer >>=  1; // shift the buffer
		if(fire)
		{
			// add the event to the bit buffer
                        triggerBuffer |= (1 << triggerWindow);
			triggerCount++;
		};
		//
                if(triggerCount < ActionOnCount) fire = false; // not enough events - switch off
		//
	};
		
	if(fire)
	{
		TriggerOnTime = t;
		statistics.clear();
		if(!Triggered && NotifyTriggerOn)
		{
			fireOn = true;
		};
	}
	else
	{
		TriggerOffTime = t;
		statistics.clear();
		if(Triggered && NotifyTriggerOff)
		{
			fireOff = true;
		};
	};
	//
	Triggered =  fire;
	UpdateTime = t;
        statistics.setValue(v);
	//
        if(fireOn) emit TriggerOn(objectName());
        if(fireOff) emit TriggerOff(objectName());
	if(fire) emit StatusChange(Status::toValue(getStatusName()));
	//
};
