#ifndef GUIHELPERS_H
#define GUIHELPERS_H
/*!
 * \file GuiHelpers.h
 *
 * \author B. J. Hill
 * \date
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <QComboBox>
#include <QString>
#include <QListWidget>
#include <QDir>
#include <QFileInfo>
#include <QFileInfoList>

/**
* @brief
*
* @fn setComboText
* @param c
* @param s
*/
inline int setComboText(QComboBox *c, QString s)
{
int res = c->findText (s);
if(res >= 0)
{
    c->setCurrentIndex(res);
}
else
{
    res = 0;
    c->setCurrentIndex(0);
}
return res;
};

//e
/**
* @brief remove by nam
*
* @fn removeComboText
* @param c
* @param s
*/
inline void removeComboText(QComboBox *c, QString s)
{
int res = c->findText (s);
if(res >= 0)
{
    c->removeItem(res);
};
}

//
/**
* @brief check items in a list  that are in a string list
*
* @fn setCheckList
* @param p
* @param l
*/
inline void setCheckList(QListWidget *p, QStringList l)
{
 if(l.count())
  {
            for(int i = 0; i < p->count(); i++)
                if(l.indexOf(p->item(i)->text()) >= 0)
                    p->item(i)->setCheckState(Qt::Checked);
    };
}

/**
* @brief
*
* @fn getComboItems
* @param p
*/
inline QStringList getComboItems(QComboBox *p)
{
QStringList l;
for(int i = 0; i < p->count(); i++)     l << p->itemText(i);
return l;
}


/**
* @brief
*
* @fn getListItems
* @param p
*/
inline QStringList getListItems(QListWidget *p)
{
QStringList l;
for(int i = 0; i < p->count(); i++)     l << p->item(i)->text();
return l;
}
// get the list of checked items in a list
/**
* @brief
*
* @fn getCheckList
* @param p
*/
inline QStringList getCheckList(QListWidget *p)
{
QStringList l;
for(int i = 0; i < p->count(); i++)
    if(p->item(i)->checkState() == Qt::Checked)
        l << p->item(i)->text();
return l;
}

/**
* @brief
*
* @fn clearCheckList
* @param p
*/
inline void clearCheckList(QListWidget *p)
{
            for(int i = 0; i < p->count(); i++)
            p->item(i)->setCheckState(Qt::Unchecked);
}

//
/**
* @brief fill a combo box with a directory listing
*
* @fn dirToCombo
* @param path
* @param filter
* @param pC
* @param stripExt
*/
inline void dirToCombo(QString path, QString filter, QComboBox *pC, bool stripExt = true)
{
QDir dir(path);
QStringList f;
f << filter;
dir.setFilter(QDir::Files | QDir::Hidden | QDir::NoSymLinks);
dir.setSorting(QDir::Size | QDir::Reversed);
dir.setNameFilters(f);

 QFileInfoList list = dir.entryInfoList();
 QStringList l;
 for (int i = 0; i < list.size(); ++i)
 {
     QFileInfo fileInfo = list.at(i);
     if(stripExt)
     {
         l << fileInfo.baseName();
     }
     else
     {
         l << fileInfo.fileName();
     }
 }
 pC->clear();
 pC->addItems(l);
}

//
/**
* @brief fill a list box with a direcotry listing
*
* @fn dirToList
* @param path
* @param filter
* @param pC
* @param stripExt
*/
inline void dirToList(QString path, QString filter, QListWidget *pC, bool stripExt = true)
{
QDir dir(path);
QStringList f;
f << filter;
dir.setFilter(QDir::Files | QDir::Hidden | QDir::NoSymLinks);
dir.setSorting(QDir::Size | QDir::Reversed);
dir.setNameFilters(f);

 QFileInfoList list = dir.entryInfoList();
 QStringList l;
 for (int i = 0; i < list.size(); ++i)
 {
     QFileInfo fileInfo = list.at(i);
     if(stripExt)
     {
         l << fileInfo.baseName();
     }
     else
     {
         l << fileInfo.fileName();
     }
 }
 pC->clear();
 pC->addItems(l);
}
#endif // GUIHELPERS_H
