#ifndef QTSSRCSPREAD_H
#define QTSSRCSPREAD_H

#include "QtSsrcSpread_global.h"
//
// This is a Qt wrapper for the SSRC Spread library, hence QtLua
// Simplified to start with may expand to any number of connections and other message options
//
#include <Utility/base.hpp>
    class QtSsrcSpreadPrivate;
    class QTSSRCSPREADSHARED_EXPORT QtSsrcSpread  : public QObject{
        Q_OBJECT
        QtSsrcSpreadPrivate *_m; // the mailbox
        QTimer _timer;
        //
        // connection parameters
        std::string _conn; // the connection
        std::string _name; // local name
        //
        void retryConnect(); // close and retry the connection
        int _retry; // retry count - doubles with each fail
        //
    public:
        QtSsrcSpread(QObject *p = 0);
        ~QtSsrcSpread();
        virtual void processMessage(QByteArray, QStringList,QString); // crack the message
        QString privateGroupName();
    public slots:
        bool spreadConnect(QString host, int port, QString localName); // connect to spread
        bool join(QString);  // join a group
        void leave(QString); // leave a group
        bool send(QString group, QByteArray data);
        void tick();
        bool doConnect();
        bool close();
    signals:
        void received(QByteArray data, QStringList groups, QString sender);
        void joinMessage(QString);
        void leaveMessage(QString);
        void disconnectSpread(QString);
        void rejectMessage(QString);
        void transitionMessage(QString);
        void membershipLeave(QString);
        void networkMessage(QByteArray);

    };
#endif // QTSSRCSPREAD_H
