#include "qtssrcspread.h"
//
// get the Ssrc Spread definitons - decouple from anything else
//
// TODO deal with connect fail - implicit retry and implicit rejoin of groups
//
#include "spread.h"
#include <Utility/trace.hpp>
#include <Utility/Logging.h>

//
class QtSsrcSpreadPrivate
{
     ssrcspread::Mailbox *_mailbox; // the mail box object
public:

    QtSsrcSpreadPrivate() : _mailbox(0)
    {

    }
    ~QtSsrcSpreadPrivate()
    {
        if(_mailbox) delete _mailbox;
    }
    void setMailbox(ssrcspread::Mailbox *m)
    {
        if(_mailbox) delete _mailbox;
        _mailbox = m;
    }
    ssrcspread::Mailbox * mailbox() const { return _mailbox;}
};




QtSsrcSpread::QtSsrcSpread(QObject *p) : QObject(p),_retry(0)
{
    _m = new QtSsrcSpreadPrivate;
    connect(&_timer,SIGNAL(timeout()),this,SLOT(tick()));

}

QtSsrcSpread::~QtSsrcSpread()
{
    if(_m) delete _m;
}
//
// this is the private name used for the spread connection - identifies the source of messages
// as servername#hostname
//
QString QtSsrcSpread::privateGroupName()
{
    QString ret;
    if(_m)
    {
        ret = QString::fromStdString(_m->mailbox()->private_group());
    }
    return ret;
}

// do the connection
bool QtSsrcSpread::spreadConnect(QString host, int port, QString localName) // connect to spread
{
    QString addr = QString("%1@%2").arg(port).arg(host);
    _conn = addr.toStdString();
    _name = localName.toStdString();
    return doConnect();
}

// do the connection this is a slot so can be retriggered on a single shot timer
bool QtSsrcSpread::doConnect()
{
    //
    if(_m && _m->mailbox()) return true; // already open
    //
    try
    {
        ssrcspread::Mailbox *m = new  ssrcspread::Mailbox(_conn,_name);
        _m->setMailbox(m); // set the mailbox
        _timer.start(100); // start the poll on success
        _retry = 0;
        return true;
    }
    catch(ssrcspread::Error e)
    {
        retryConnect();
        qxtLog->error(LM,QString("Spread Connection Failed - Retrying[%1]").arg(e.error()));
    }
    return false;
}

void QtSsrcSpread::retryConnect()
{
    _retry = _retry * 2 + 1;
    if(_retry > 600) _retry = 600;
    close();
    QTimer::singleShot(1000 * _retry,this,SLOT(doConnect()));
}

void QtSsrcSpread::close()
{
    _timer.stop(); // stop polling
    if(_m) delete _m;
    _m = 0;
}

bool QtSsrcSpread::join(QString g)  // join a group
{
    if(_m && _m->mailbox())
    {
        _m->mailbox()->join(g.toStdString());
        return true;
    }
    return false;
}

void QtSsrcSpread::leave(QString g) // leave a group
{
    if(_m && _m->mailbox())
    {
        _m->mailbox()->leave(g.toStdString());
    }

}

// send a vanilla message - may have to be expanded to add other feature
bool QtSsrcSpread::send(QString group, QByteArray data)
{
    if(_m && _m->mailbox())
    {
        try
        {
            ssrcspread::Message m; // create the message as default
            m.write(data.data(),data.size());
            _m->mailbox()->send(m,group.toStdString());
            return true;
        }
        catch(ssrcspread::Error e)
        {
            qxtLog->error(LM,QString("Send Error [%1]").arg(e.error()));
            e.print();
        }
    }
    return false;
}

// Derived classes process the message according to application. Eg data could be XmlRPC or JSON
void QtSsrcSpread::processMessage(QByteArray /*data*/, QStringList /*groups*/, QString /*sender*/) // crack the message
{

}
//
void QtSsrcSpread::tick()
{
    if(_m && _m->mailbox())
    {
        try
        {
            while(_m->mailbox()->poll() > 0)
            {
                ssrcspread::Message m;
                ssrcspread::GroupList g;
                int n = _m->mailbox()->receive(m,g);
                QByteArray b(n,'\0');
                m.read(b.data(),n);
                //
                QStringList groups;
                for(int i = 0; i < (int)g.size(); i++)
                {
                    groups << QString::fromStdString(g.group(i));
                }
                emit received(b,groups,QString::fromStdString(m.sender())); // say we have received a message
                //
                // now crack the message
                //
                if(m.is_membership()) // membership message - join or leave
                {
                    // unpack the membership information
                    // generate the join and leave signals
                    Spread::membership_info  memb_info;
                    int ret = Spread::SP_get_memb_info( b.data(), m.service(), &memb_info );
                    if(ret < 0) return;

                    if( Is_caused_join_mess( m.service() ) )
                    {

                        retryConnect();               emit joinMessage(QString(memb_info.changed_member));
                    }else if( Is_caused_leave_mess( m.service() ) ){
                        emit leaveMessage(QString(memb_info.changed_member));
                    }else if( Is_caused_disconnect_mess( m.service() ) ){
                      emit disconnectSpread(QString(memb_info.changed_member));
                    }else if( Is_caused_network_mess( m.service() ) ){
                        emit networkMessage(b);
                    }
                    else if( Is_transition_mess(   m.service() ) ) {
                        transitionMessage(QString::fromStdString(m.sender()));
                    }else if( Is_caused_leave_mess( m.service()) ){
                         membershipLeave(QString::fromStdString(m.sender()));
                    }
                }
                else if(Is_regular_mess( m.service()) )
                {
                    // remove messages to self
                    if(m.sender() != _m->mailbox()->private_group())
                    {
                        processMessage(b,groups,QString::fromStdString(m.sender())); // derived classes may emit other signals
                    }
                }
                else if ( Is_reject_mess( m.service()))
                {
                    emit rejectMessage(QString::fromStdString(m.sender()));
                }
            }
        }
        catch(ssrcspread::Error e)
        {
            qxtLog->error(LM,QString("Spread Connection Lost - Retrying [%1]").arg(e.error()));
            e.print();
            retryConnect(); // schedule a reconnection
        }
    }
}
