#ifndef UDPPACKETDRIVER_H
#define UDPPACKETDRIVER_H
/*!
 * \file udppacketdriver.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <Utility/base.hpp>
#include "packetdriver.h"
#include <QAbstractSocket>
#include <QUdpSocket>
#include "MrlHardware_global.h"

/*!
 * \class UdpPacketDriver
 *
 * \brief Packet driver that uses UDP to send a receive packets. UDP is connectionless and practically has a packet
 size limit of about 500 bytes. There is no way to determine if a server is present save the absence of responses.
 *
 *
 * \author B. J. Hill
 * \date
 */
// this packet driver uses UDP - connectionless but the other end is always unknown
class UdpPacketDriver : public PacketDriver
{
    Q_OBJECT
    //
    QString _host; // host name
    int _port; // UDP port name
    QUdpSocket *_udpChan; // UDP channel
        int _retryTime;
    //
public:
    /**
     * @brief Constructs and opens a connection to the given host and port. This uses the QUdpSocket
     concept of a UDP connection. A connection does not know if the other end is present.
     *
     * @param host Host to connect to
     * @param port Port to conenct to
     * @param parent Parent QObject
    */
    explicit UdpPacketDriver(QString host, int port,QObject *parent = 0);
    /**
     * @brief Destructor
     *
    */
    ~UdpPacketDriver();
    /**
     * @brief Returns the host connected to
     *
     * @return QString
    */
    QString host() const { return _host;}
    /**
     * @brief Returns the network port number
     *
     * @return int
    */
    int port() const { return _port;}
    /**
     * @brief Returns true is the connection is valid. UDP connections should always be valid.
     *
    */
    bool canSend()
    {
        return _udpChan && (_udpChan->state() == QAbstractSocket::ConnectedState);
    }

    /**
     * @brief Fetch the UDP packet and return
     *
     * @return bool
    */
    bool getPacket();

signals:

public slots:
    // UDP connections do not know about the other end really
    void connectToHost();
    void connected ();
    void disconnected ();
    void error ( QAbstractSocket::SocketError socketError );
    void hostFound ();
};

#endif // UDPPACKETDRIVER_H
