#include "udppacketdriver.h"

/**
 * @brief
 *
 * @param host
 * @param port
 * @param parent
 * @return
*/
UdpPacketDriver::UdpPacketDriver(QString host, int port ,QObject *parent) :
        PacketDriver(QString("UDP:%1:%2").arg(host).arg(port),parent),
        _host(host),_port(port),_udpChan(0),_retryTime(0)
{
    _udpChan = new QUdpSocket(this);
    setIoDevice(_udpChan);
    //
    connect(_udpChan, SIGNAL(connected()),this,SLOT(connected()));
    connect(_udpChan, SIGNAL(disconnected()),this,SLOT(disconnected()));
    connect(_udpChan,SIGNAL(error(QAbstractSocket::SocketError)),
            this,SLOT(error(QAbstractSocket::SocketError)));
    connectToHost();
}

/**
 * @brief
 *
*/
UdpPacketDriver::~UdpPacketDriver()
{
    if(_udpChan)
    {
        _udpChan->close();
        _udpChan->deleteLater();
    }
}


/**
 * @brief
 *
*/
void UdpPacketDriver::connectToHost()
{
    if(_udpChan) _udpChan->connectToHost(_host,_port);
}

/**
 * @brief
 *
*/
void UdpPacketDriver::connected ()
{
    DBG("Connected " << _host << " port " << _port)
    _retryTime = 1000; // reset retry time
}

/**
 * @brief
 *
*/
void UdpPacketDriver::disconnected ()
{
    DBG("Disconnected " << _host << " port " << _port)
    // try to reconnect
    QTimer::singleShot(_retryTime,this,SLOT(connectToHost()));
    _retryTime *= 2; // double time between tries
}

/**
 * @brief
 *
 * @param socketError
*/
void UdpPacketDriver::error ( QAbstractSocket::SocketError
#ifdef DEBUGON
                              socketError
#endif
                              )
{
    DBG("Error " << socketError << " host " << _host << " port " << _port)
    QTimer::singleShot(_retryTime,this,SLOT(connectToHost()));
    _retryTime *= 2;
}

/**
 * @brief
 *
*/
void UdpPacketDriver::hostFound ()
{
   DBG("Found host " << _host  << " port " << _port)
}

 /**
  * @brief
  *
  * @return bool
 */
 bool UdpPacketDriver::getPacket()
 {
     bool ret = false;
     if(_udpChan->hasPendingDatagrams())
     {
         QByteArray b;
         QHostAddress sender;
         quint16 senderPort;
         b.resize(_udpChan->pendingDatagramSize());
         _udpChan->readDatagram(b.data(), b.size(),&sender, &senderPort);
         DBG("Have datagram " << byteArrayToString(b))
         _rx.close();
         _rx.buffer().clear();
         _rx.open(QIODevice::ReadWrite);
         _rx.write(b);
         sendResponse();
         ret = true;
     }
     return ret;
 }
