#ifndef TCPPACKETDRIVER_H
#define TCPPACKETDRIVER_H
/*!
 * \file tcppacketdriver.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <Utility/base.hpp>
#include "packetdriver.h"
#include <QAbstractSocket>
#include <QTcpSocket>
#include "MrlHardware_global.h"
/*!
 * \class TcpPacketDriver
 *
 * \brief This is packet driver that operates over a TCP stream.
 * The packet driver will attempt to reconnect on disconnect or failure, doubling the retry time until success.
 *
 * \author B. J. Hill
 */
class MRLHARDWARESHARED_EXPORT TcpPacketDriver : public PacketDriver
{
    Q_OBJECT
    QString _host; // host name
    int _port; // TCP port name
    QTcpSocket *_tcpChan; // TCP channel
    int _retryTime;
public:
    /**
     * @brief Constructs the packet driver connecting to the named host (IP address) and port.
     *
     * @param host Hostname or address to connect to
     * @param port The port number
     * @param parent Parent QObject
    */
    explicit TcpPacketDriver(QString host, int port ,QObject *parent);
    /**
     * @brief Destructor
     *
    */
    ~TcpPacketDriver();
    //
    /**
     * @brief Test to see if it possible to send a request.
     *
     * @return bool
    */
    bool canSend()
    {
        return _tcpChan && (_tcpChan->state() == QAbstractSocket::ConnectedState);
    }
    /**
     * @brief Returns the host name for the connection
     *
     * @return QString
    */
    QString host() const { return _host;}
    /**
     * @brief Returns the port number
     *
     * @return int
    */
    int port() const { return _port;}
    //

public slots:
    void connected ();
    void disconnected ();
    void error ( QAbstractSocket::SocketError socketError );
    void hostFound ();
    void connectToHost();
};

// ten minutes max retry time
#define TCP_PACKET_DRIVER_MAX_RETRYTIME (600000)
//
#endif // TCPPACKETDRIVER_H
