#include "tcppacketdriver.h"
/*!
 * \file tcppacketdriver.cpp
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

/**
 * @brief
 *
 * @param host
 * @param port
 * @param parent
 * @return
*/
TcpPacketDriver::TcpPacketDriver(QString host, int port ,QObject *parent) :
        PacketDriver(QString("TCP:%1:%2").arg(host).arg(port),parent),
        _host(host),_port(port),_tcpChan(0),_retryTime(1000)
{
    DBG("host " << host << " port " << port)
    _tcpChan = new QTcpSocket(this);
    connect(_tcpChan, SIGNAL(connected()),this,SLOT(connected()));
    connect(_tcpChan, SIGNAL(disconnected()),this,SLOT(disconnected()));
    connect(_tcpChan,SIGNAL(error(QAbstractSocket::SocketError)),
            this,SLOT(error(QAbstractSocket::SocketError)));
        setIoDevice(_tcpChan);
        connectToHost();
}


/**
 * @brief
 *
*/
TcpPacketDriver::~TcpPacketDriver()
{
    if(_tcpChan)
    {
        _tcpChan->close();
        _tcpChan->deleteLater();
    }
}


/**
 * @brief
 *
*/
void TcpPacketDriver::connected ()
{
    DBG("Connected " << _host << " port " << _port)
    _retryTime = 1000; // reset retry time
}

/**
 * @brief
 *
*/
void TcpPacketDriver::disconnected ()
{
    DBG("Disconnected " << _host << " port " << _port)
    // try to reconnect
    QTimer::singleShot(_retryTime,this,SLOT(connectToHost()));
    _retryTime *= 2; // double time between tries
}

/**
 * @brief
 *
 * @param socketError
*/
void TcpPacketDriver::error ( QAbstractSocket::SocketError
#ifdef DEBUGON
                              socketError
#endif
                              )
{
    DBG("Error " << socketError << " host " << _host << " port " << _port)
    QTimer::singleShot(_retryTime,this,SLOT(connectToHost()));
    _retryTime *= 2;
}

/**
 * @brief
 *
*/
void TcpPacketDriver::hostFound ()
{
   DBG("Found host " << _host  << " port " << _port)
}

/**
 * @brief
 *
*/
void TcpPacketDriver::connectToHost()
{
    if(_retryTime > TCP_PACKET_DRIVER_MAX_RETRYTIME)
        _retryTime = TCP_PACKET_DRIVER_MAX_RETRYTIME;
    if(_tcpChan) _tcpChan->connectToHost(_host,_port);
}
