//
// (c) B. J. Hill 2007 -
// Purpose: Server Resource collection and reporting
// $Id$
//
#include "serverresources.h"
#include <QSqlDatabase>
#include <MrlHardware/qextserialport.h>

ServerResources::ServerResources()
{
}


// detect which serial ports are present
QStringList ServerResources::detectSerialPorts()
{
	QStringList l;
#ifdef Q_OS_WIN32
#endif

#ifdef Q_OS_LINUX
	DBG("Getting Serial Port List")
		QDir dir("/dev");
	QStringList m;
	m << "ttyS*" << "ttyUSB*" << "ttyACM*";
	l = dir.entryList(m,QDir::System | QDir::CaseSensitive);
        //DBG("Got List" << l.join("\n"))
	#endif
		return l;
}


// get the available database types
QStringList ServerResources::detectDatabaseTypes()
{
	return QSqlDatabase::drivers ();
}


XMLTraversal & ServerResources::toXML(XMLTraversal &x)
{
// assumes (!) a blank XML file
	x.push();
	x.mkdirAndCd("ServerResources");
	databases.toXML(x);
	XMLSET(x,availableSerialPorts);
	XMLSET(x,databaseTypes);
	x.pop();
	return x;
}


XMLTraversal & ServerResources::fromXML(XMLTraversal &x)
{
	x.push();
        if(x.cd("ServerResources"))
	{
            databases.fromXML(x);
            XMLGET(x,availableSerialPorts);
            XMLGET(x,databaseTypes)
 	}
	x.pop();
	return x;
}


XMLTraversal & ServerDatabaseMap::toXML(XMLTraversal &x)
{
        x.push();
	x.mkdirAndCd("Databases");
	for(ServerDatabaseMap::iterator i = begin();i != end(); ++i)
	{
		i.value().toXML(x);
	}
	x.pop();
	return x;
}


XMLTraversal & ServerDatabaseMap::fromXML(XMLTraversal &x)
{
	clear();
	x.push();
	if(x.cd("Databases"))
	{
// list of ports
		QStringList l = x.ls();
                for(int i = 0; i < l.count(); i++)
		{
			x.push();
			ServerDatabase s(l[i]);
			s.fromXML(x);
			insert(l[i],s);
			x.pop();
		}
	}
	x.pop();
	return x;
}


XMLTraversal & SerialPortResourceMap::toXML(XMLTraversal &x)
{
        x.push();
	x.mkdirAndCd("SerialPorts");
	for(SerialPortResourceMap::iterator i = begin();i != end(); ++i)
	{
                x.mkdirAndCd(i.key());
		i.value().toXML(x);
	}
	x.pop();
	return x;
}


XMLTraversal & SerialPortResourceMap::fromXML(XMLTraversal &x)
{
	clear();
	x.push();
	if(x.cd("SerialPorts"))
	{
// list of ports
		QStringList l = x.ls();
		for(int i = 0; i < l.count(); i++)
		{
			x.push();
                        if(x.cd(l[i]))
                        {
                            SerialPortResource s;
                            s.fromXML(x);
                            insert(l[i],s);
                        }
			x.pop();
		}
	}
	x.pop();
	return x;
}


// port settings
void SerialPortResource::toPortSettings(PortSettings &ps)
{
    // default
    ps.BaudRate = BAUD9600;
    ps.DataBits = DATA_8;
    ps.Parity = PAR_NONE;
    ps.StopBits = STOP_1;
    ps.FlowControl = FLOW_OFF;
    ps.Timeout_Sec = 1;
    ps.Timeout_Millisec = 0;
    //
    switch(speed())
    {
                case 50:
                ps.BaudRate = BAUD50;
                break;
                //
                case 75:
                ps.BaudRate = BAUD75;
                break;
                //
                case 110:
                ps.BaudRate = BAUD110;
                break;
                //
                case 300:
                ps.BaudRate = BAUD300;
                break;
                //
                case 600:
                ps.BaudRate = BAUD600;
                break;
                //
                case 1200:
                ps.BaudRate = BAUD1200;
                break;
                //
                case 2400:
                ps.BaudRate = BAUD2400;
                break;
                //
                case 4800:
                ps.BaudRate = BAUD4800;
                break;
                //
                case 9600:
                ps.BaudRate = BAUD9600;
                break;
                //
                case 19200:
                ps.BaudRate = BAUD19200;
                break;
                //
                case 38400:
                ps.BaudRate = BAUD38400;
                break;
                //
                case 57600:
                ps.BaudRate = BAUD57600;
                break;
                //
                case 115200:
                ps.BaudRate = BAUD115200;
                break;
                //
                default:
               break;
    }
    switch(dataBits())
    {
    case  5:
        ps.DataBits = DATA_5;
        break;
    case  6:
        ps.DataBits = DATA_6;
        break;
    case  7:
        ps.DataBits = DATA_7;
        break;
    case  8:
        ps.DataBits = DATA_8;
        break;
    default:
        break;
    }

    switch(parity())
    {
    case Odd:
        ps.Parity = PAR_ODD;
        break;
    case Even:
        ps.Parity = PAR_EVEN;
        break;
    case NoParity:
        ps.Parity = PAR_NONE;
        break;
    default:
        break;
    }

    switch(stopBits())
    {
    case 1:
        ps.StopBits =  STOP_1;
        break;
    case 2:
        ps.StopBits =  STOP_1;
        break;
    default:
        break;
    }

    ps.FlowControl = FLOW_OFF;
    ps.Timeout_Sec = 1;
    ps.Timeout_Millisec = 0;

}

