#ifndef SERIALPACKETDRIVER_H
#define SERIALPACKETDRIVER_H
/*!
 * \file serialpacketdriver.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */
#include "packetdriver.h"
#include "qextserialport.h"
#include "MrlHardware_global.h"
/*!
 * \class SerialPacketDriver
 *
 * \brief This is a packet driver that operates over a serial port
 *
 * This packet driver sends are receives over the named serial port using the QextSerialPort class.
 *
 * \author B. J. Hill
 * \date
 */
class MRLHARDWARESHARED_EXPORT SerialPacketDriver : public PacketDriver
{
    Q_OBJECT
    QextSerialPort * _serialPort; // the serial port
public:
    /**
     * @brief Constructs packet driver
     *
     * @param name Packet driver name.
     * @param parent Parent QObject
    */
    explicit SerialPacketDriver(QString name ,QObject *parent = 0);
    /**
     * @brief Destructor
     *
    */
    ~SerialPacketDriver();
    /**
     * @brief Returns the current serial port object
     *
     * @return QextSerialPort *
    */
    QextSerialPort * serialPort() const { return _serialPort;}
    /**
     * @brief Sets the serial port object
     *
     * @param s
    */
    void setSerialPort(QextSerialPort *s)
    {
        setIoDevice(s);
        _serialPort = s;
    }

    /**
     * @brief create and open a serial port interface
     *
     * @param dev device name
     * @param ps
     * @return bool
    */
    bool setSerialPort(QString dev, const PortSettings &ps );

    /**
     * @brief Clears the serial port's send and receive buffers
     *
    */
    void flush()
    {
        if(_serialPort) _serialPort->flush();
    }
};

#endif // SERIALPACKETDRIVER_H
