#include "serialpacketdriver.h"
/*!
 * \file serialpacketdriver.cpp
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

/**
 * @brief
 *
 * @param n
 * @param parent
 * @return
*/
SerialPacketDriver::SerialPacketDriver(QString n, QObject *parent) :
    PacketDriver(n, parent),_serialPort(0)
{

}

/**
 * @brief Destructor
 *
*/
SerialPacketDriver::~SerialPacketDriver()
{
    if(_serialPort)
    {
        _serialPort->close();
        delete _serialPort;
    }
}
/**
 * @brief
 *
 * @param dev
 * @param ps
 * @return bool
*/
bool SerialPacketDriver::setSerialPort(QString dev, const PortSettings &ps )
{
    DBG("Device " << dev)
    setIoDevice(0);
    if(_serialPort)
    {
        delete _serialPort;
        _serialPort = 0;
    }

    _serialPort = new QextSerialPort(
#ifdef Q_OS_WIN32
            dev,
#else
            QString("/dev/%1").arg(dev),
#endif
            ps);
    bool ret = _serialPort->open(QIODevice::ReadWrite);
    DBG("Serial Port Open " << (ret?"true":"false"))
    if(ret)
    {
        setIoDevice(_serialPort);
    }
    else if(_serialPort)
    {
        delete _serialPort;
        _serialPort = 0;
    }
    return ret;
}
