/*
	Autor: Oldani Sebastian. Argentina. Santa Fe
	
	El codigo original pertenece a Stefan Sander, solo hice las
	adaptaciones para convertirlo en widgets
	
	email: sebastianoldani@gmail.com
	
    This file is part of QPort.

    QPort is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    QPort is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with QPort.  If not, see <http://www.gnu.org/licenses/>.
    
	Autor: Oldani Sebastian. Argentina. Santa Fe
	email: sebastianoldani@gmail.com
*/
#ifndef _QEXTSERIALPORT_H_
#define _QEXTSERIALPORT_H_

#include "MrlHardware_global.h"

#ifdef _WINDOWS
    //#define _TTY_WIN_
    #undef _TTY_POSIX_
#else
    #ifndef _TTY_POSIX_
        #define _TTY_POSIX_
    #endif
#endif

/*POSIX CODE*/
#ifdef _TTY_POSIX_
#include "posix_qextserialport.h"
#define QextBaseType Posix_QextSerialPort

/*MS WINDOWS CODE*/
#else
#include "win_qextserialport.h"
#define QextBaseType Win_QextSerialPort
#endif

class MRLHARDWARESHARED_EXPORT QextSerialPort: public QextBaseType
{
    // adds RTTI
    Q_OBJECT
public:
    QextSerialPort();
    QextSerialPort(const QString & name);
    QextSerialPort(const PortSettings& s);
    QextSerialPort(const QString & name, const PortSettings & s);
    QextSerialPort(const QextSerialPort& s);
    QextSerialPort& operator=(const QextSerialPort&);
    virtual ~QextSerialPort();
protected:
    void timerEvent ( QTimerEvent * event );
};

#endif
