/*
	Autor: Oldani Sebastian. Argentina. Santa Fe
	
	El codigo original pertenece a Stefan Sander, solo hice las
	adaptaciones para convertirlo en widgets
	
	email: sebastianoldani@gmail.com
	
    This file is part of QPort.

    QPort is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    QPort is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with QPort.  If not, see <http://www.gnu.org/licenses/>.
    
	Autor: Oldani Sebastian. Argentina. Santa Fe
	email: sebastianoldani@gmail.com
*/
#ifndef _POSIX_QEXTSERIALPORT_H_
#define _POSIX_QEXTSERIALPORT_H_

#include <stdio.h>
#include <termios.h>
#include <errno.h>
#include <unistd.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include "qextserialbase.h"
#include "MrlHardware_global.h"

class MRLHARDWARESHARED_EXPORT Posix_QextSerialPort:public QextSerialBase {
public:
	Posix_QextSerialPort();
	Posix_QextSerialPort(const Posix_QextSerialPort& s);
        Posix_QextSerialPort(QString name);
	Posix_QextSerialPort(const PortSettings& settings);
        Posix_QextSerialPort(QString name, const PortSettings& settings);
	Posix_QextSerialPort& operator=(const Posix_QextSerialPort& s);
	virtual ~Posix_QextSerialPort();
	
	virtual void setBaudRate(BaudRateType);
	virtual void setDataBits(DataBitsType);
	virtual void setParity(ParityType);
	virtual void setStopBits(StopBitsType);
	virtual void setFlowControl(FlowType);
	virtual void setTimeout(ulong, ulong);
	
	virtual bool open(OpenMode mode=0);
	virtual void close();
	virtual void flush();
	
	virtual qint64 size() const;
	virtual qint64 bytesAvailable();
	
	virtual void ungetChar(char c);
	
	virtual void translateError(ulong error);
	
	virtual void setDtr(bool set=true);
	virtual void setRts(bool set=true);
	virtual ulong lineStatus();
	
protected:
        int    Posix_File;
	struct termios Posix_CommConfig;
	struct timeval Posix_Timeout;
	struct timeval Posix_Copy_Timeout;
	
	virtual qint64 readData(char * data, qint64 maxSize);
	virtual qint64 writeData(const char * data, qint64 maxSize);
};

#endif
