#include "quickfill.h"

//stack friendly and fast floodfill algorithm
void floodFillScanline(int x, int y, Uint32 newColor, Uint32 oldColor)
{
    if(oldColor == newColor) return;
    if(screenBuffer[x][y] != oldColor) return;

    int y1;

    //draw current scanline from start position to the top
    y1 = y;
    while(screenBuffer[x][y1] == oldColor && y1 < h)
    {
        screenBuffer[x][y1] = newColor;
        y1++;
    }

    //draw current scanline from start position to the bottom
    y1 = y - 1;
    while(screenBuffer[x][y1] == oldColor && y1 >= 0)
    {
        screenBuffer[x][y1] = newColor;
        y1--;
    }

    //test for new scanlines to the left
    y1 = y;
    while(screenBuffer[x][y1] == newColor && y1 < h)
    {
        if(x > 0 && screenBuffer[x - 1][y1] == oldColor)
        {
            floodFillScanline(x - 1, y1, newColor, oldColor);
        }
        y1++;
    }
    y1 = y - 1;
    while(screenBuffer[x][y1] == newColor && y1 >= 0)
    {
        if(x > 0 && screenBuffer[x - 1][y1] == oldColor)
        {
            floodFillScanline(x - 1, y1, newColor, oldColor);
        }
        y1--;
    }

    //test for new scanlines to the right
    y1 = y;
    while(screenBuffer[x][y1] == newColor && y1 < h)
    {
        if(x < w - 1 && screenBuffer[x + 1][y1] == oldColor)
        {
            floodFillScanline(x + 1, y1, newColor, oldColor);
        }
        y1++;
    }
    y1 = y - 1;
    while(screenBuffer[x][y1] == newColor && y1 >= 0)
    {
        if(x < w - 1 && screenBuffer[x + 1][y1] == oldColor)
        {
            floodFillScanline(x + 1, y1, newColor, oldColor);
        }
        y1--;
    }
}
