#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <base.hpp>

namespace Ui
{
    class MainWindow;
}


    class ProcessThread : public QThread
    {
        Q_OBJECT
        QString SrcDir; // source directory
        QString DestFile;  // destination file to write results as CSV
        int Threshold; // threshold to remove background
        double MinR; // filter min radius
        double MaxR; // filter max radius
        double MinC; // minimum circularity
        double PixToUm; // conversion from pixels to um
        bool autoCorrect;
        public:
        // thread with all the parameters
        ProcessThread(QString srcDir, QString destFile, int threshold, double minR, double maxR, double minC, double pixToum, bool ac)
        :SrcDir(srcDir),DestFile(destFile),Threshold(threshold),MinR(minR),MaxR(maxR),MinC(minC),PixToUm(pixToum),autoCorrect(ac)
        {

        }

        void run();
        void processDir(QString srcDir,  QTextStream &os, QTextStream &sumS); // process one directory
        Q_SIGNALS:
        void value(int); // step

    };


class MainWindow : public QMainWindow
{
    Q_OBJECT
    QString fileName; // current file
    QPixmap inputPx;
    QImage inImage; // input image
    QImage bkImage;


public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void showImage(QImage i, QLabel *l);
private:
    Ui::MainWindow *ui;

private slots:
    void on_actionSave_Results_triggered();
    void on_actionProcess_Directory_triggered();
    void on_actionDetect_Particles_triggered();
    void on_actionRemove_baseline_triggered();
    void on_actionE_xit_triggered();
    void on_action_Open_triggered();
};

#endif // MAINWINDOW_H
