#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "ImageFunctions.h"

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow)
{
    ui->setupUi(this);
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_action_Open_triggered()
{
    // open and load a JPEG file with the sile image in it
   fileName = QFileDialog::getOpenFileName(this,
     tr("Open Image"), QString(), tr("Image Files (*.png *.jpg *.bmp)"));
   if(!fileName.isEmpty())
   {
       if(LoadImage(fileName, inImage))
       {
            showImage(inImage,ui->InputImage);
            int i = GuessBackground(inImage);
            ui->Threshold->setValue(i);
       }
   }
}

void MainWindow::on_actionE_xit_triggered()
{
    qApp->quit();
}

void MainWindow::on_actionRemove_baseline_triggered()
{
    if(!inImage.isNull())
    {
        bkImage = inImage.copy(0,0,inImage.width(),inImage.height());
        RemoveBackground(bkImage, ui->Threshold->value()); // remove the background
        showImage(bkImage, ui->baselineRemoved); // show the result
   }
}

 void MainWindow::showImage(QImage i, QLabel  *l)
 {
        QPixmap px = QPixmap::fromImage(i);
        l->setPixmap(px);
}

void MainWindow::on_actionDetect_Particles_triggered()
{
    if(!bkImage.isNull())
    {
        CircleList cl;
        QImage oi(bkImage.width(),bkImage.height(),QImage::Format_RGB32);
        oi.fill(0);
         DetectParticles(bkImage, cl);
         QPainter dc(&oi);
         dc.setPen(Qt::lightGray);
         dc.setBrush(Qt::red);
        //
        double minR = ui->MinR->value();
        double maxR = ui->MaxR->value();
        double minC = ui->Circularity->value();
        //
        double PixToUm = ui->PixelsPerUm->value();
        double sd = 0;
        double sd3 = 0;
        ui->resultsList->clear();
        int n = 0;
         ui->resultsList->addItem("X,Y,R(pixel),R(um),C,I");
         for(int i = 0; i < cl.count(); i++)
         {
             Circle c = cl[i];
             if((c.radius > minR) && (c.radius < maxR) && (c.circularity > minC)) // filter
             {
                dc.drawEllipse ( c.pt, (int)c.radius,(int)c.radius );
                ui->resultsList->addItem(QString("%1,%2, %3, %4, %5, %6")
                                 .arg(c.pt.x())
                                 .arg(c.pt.y())
                                 .arg(c.radius) // radius in pixels
                                 .arg(c.radius / PixToUm) // radius in um
                                 .arg(c.circularity)
                                 .arg(c.intensity));
                         sd += c.radius *2;
                         sd3 += c.radius*c.radius*c.radius *8;
                         n++;
            };
         }
         dc.end();
         showImage(oi, ui->detectedImage);
                              // save the NMD and VMD
         if(n > 0)
         {
           ui->resultsList->addItem( QString("NMD = %1  VMD = %2")
                            .arg(sd   / PixToUm / n)
                            .arg(pow( sd3 / n,0.3333333333) / PixToUm ));
       }

    }
}


void ProcessThread::processDir(QString srcDir,  QTextStream &os, QTextStream &sumS)
{
    // for the current directory - get the PNG files
    QDir d(srcDir,"*.png");
    DBG(srcDir);
    QFileInfoList list = d.entryInfoList();
    //
        QStringList sumres;
        for (int i = 0; i < list.size(); ++i)
        {
            emit value(i + 1);
             QFileInfo fileInfo = list.at(i);
             // load the image
             QImage im;
             if(LoadImage(list.at(i).filePath(),im))
             {
                 //
                 // remove the baseline
                 int th = Threshold;
                 if(autoCorrect)
                 {
                     th = GuessBackground(im);
                 }
                 RemoveBackground(im, th);
                 //
                 CircleList cl;
                 // detect particles
                 DetectParticles(im, cl);
                //
                 os << "***" << endl;
                 os << list.at(i).baseName() << endl;
                 os << "X,Y,R(pixel),R(um),C,I" << endl;
                 //
                 // we have to calculate the NMD and VMD
                 //
                 double sd = 0;
                 double sd3 =0;
                 int n = 0;
                 for(int j = 0; j < cl.count(); j++)
                 {
                     Circle c = cl[j];
                     if((c.radius > MinR) && (c.radius < MaxR) && (c.circularity > MinC)) // filter
                     {
                         os << QString("%1,%2,%3,%4,%5,%6")
                                 .arg(c.pt.x())
                                 .arg(c.pt.y())
                                 .arg(c.radius) // radius in pixels
                                 .arg(c.radius / PixToUm) // radius in um
                                 .arg(c.circularity)
                                 .arg(c.intensity) << endl;
                         n++;
                         sd += c.radius *2;
                         sd3 += c.radius*c.radius*c.radius *8;
                    };
                 }
                 if(n > 0)
                 {
                     // save the NMD and VMD
                    sumres << QString("%1,%2,%3")
                            .arg(list.at(i).baseName())
                            .arg(sd /PixToUm  / n)
                            .arg(pow( sd3 / n,0.3333333333) /  PixToUm);
                }
                 os << endl;
             }
         }
    //
    // write the summaries
    //
   sumS << endl << sumres.join("\n");
    //
    //
    // now get sub directories
    //
    //
   QDir sd(srcDir);
    QFileInfoList sdlist = sd.entryInfoList();
    //
    DBG("Number of entries" << sdlist.size());
    // now iterate
    //
    for (int i = 0; i < sdlist.size(); ++i)
     {
         QFileInfo fileInfo = sdlist.at(i);
         if(fileInfo.isDir())
         {
           // DBG("Directory " << fileInfo.filePath() << " Name " << fileInfo.fileName());
           QString p = fileInfo.fileName();
           if(!p.startsWith('.')) // ignore current and parent
           {
             processDir(fileInfo.filePath(), os, sumS);
           };
         }
    };
}


void ProcessThread::run()
{
    // get the directory of jpeg files
   QFile of(DestFile);
    if(of.open(QIODevice::WriteOnly))
    {
        QTextStream os(&of);
        QFile sf(QString("%1.Summary.csv").arg(DestFile));
        if(sf.open(QIODevice::WriteOnly))
        {
            QTextStream ss(&sf);
          ss << "Image,NMD,VMD" << endl;
            processDir(SrcDir, os, ss);
        };
    };
}


void MainWindow::on_actionProcess_Directory_triggered()
{
    //
    // process a whole directory - spin a thread of to do this
    //
    // get the source directory
    //
     QString dir = QFileDialog::getExistingDirectory(this, tr("Source Directory"),
                                                     QString(),
                                                     QFileDialog::ShowDirsOnly
                                                     | QFileDialog::DontResolveSymlinks);
     if(!dir.isEmpty())
     {
             QDir d(dir,"*.jpg");
            //
            QFileInfoList list = d.entryInfoList();

             // get the save file name (CSV)
            //
             QString fileName = QFileDialog::getSaveFileName(this, tr("Save File"),
                                        QString(),
                                        tr("CSV (*.csv)"));
            if(!fileName.isEmpty())
             {
                    // start the thread
                    //
                   ProcessThread *pT = new ProcessThread(dir,fileName,
                                                         ui->Threshold->value(),ui->MinR->value(),ui->MaxR->value(),
                                                         ui->Circularity->value(),ui->PixelsPerUm->value(), ui->autoSetThreshold->isChecked());

                   QProgressDialog dlg(QString("Process Directory:%1").arg(dir),"Cancel",0,list.size() + 1,this);
                   connect(pT,SIGNAL(value(int)),&dlg,SLOT(setValue(int))); // update value
                   connect(pT,SIGNAL(finished()),&dlg,SLOT(cancel())); // conpleted
                   pT->start();
                   dlg.exec();
                   pT->quit();
                   pT->deleteLater();
        }
    }
}

void MainWindow::on_actionSave_Results_triggered()
{
    // save a set of results
   QString fileName = QFileDialog::getSaveFileName(this, tr("Save File"),
                           "Results.csv",
                            tr("CSV (*.csv)"));
   if(!fileName.isEmpty())
   {
           QFile f(fileName);
           if(f.open(QIODevice::WriteOnly))
           {
               QTextStream os(&f);
               for(int i = 0; i < ui->resultsList->count();i++)
               {
                   os << ui->resultsList->item(i)->text() << endl;
               }
           }
   }
}
