#ifndef IMAGEPROCESSOR_H
#define IMAGEPROCESSOR_H
#include "ImageFunctions.h"

// this class performs the image processing as a class rather than as routines
class ImageProcessor
{
    QImage base; // the start image
    QImage clean; // background removed (zeroed)
    CircleList points; // the points
    int imageSize;
    QList<QPoint> edgeList; // list of edge pixels
    //
    // Fill variables
    //
    unsigned area; // number of pixels in fill
    static unsigned intensity; // sum of values

    QStack<QPoint> stack;
    // pixel setter and getter - operates on cleaned image
    void SetPixel(int x, int y, uchar c)
    {

        *(clean.bits() + x + y * clean.width()) = c;
    };
    uchar GetPixel(int x, int y)
    {
        return *(clean.bits() + x + y * clean.width());
    }
    // this algorithm uses a global stack of pixel coordinates
    void pushSeed(int x, int y)
    {
        QPoint p(x,y);
        stack.push(p);
    }
    bool popSeed(int &x, int &y)
    {
        if(stack.count())
        {
            x = stack.top().x();
            y = stack.top().y();
            stack.pop();
            return true;
        }
        return false;
    }


// the set it up and kick it off routine.
void SeedFill(int x, int y)
{
   // we assume the stack is created empty, and that no other
   // routines or threads are using this stack for anything
   pushSeed(x, y);
   FillSeedsOnStack();
}

void FillSeedsOnStack(); // the fill routine
void FillContiguousSpan(int x, int y, int &xLeft, int &xRight);

public:
    ImageProcessor(QImage i) :
            base(i),
            imageSize(i.width() * i.height())
            {}
    // clear the background
    void RemoveBackground(uchar t)
    {
        clean = base.copy();
        uchar * p = clean.bits();
        for(int i = 0; i < imageSize;i++,p++) if(*p < t) *p = 0;
    }
    //
    int GetThreshold() { return GuessBackground(base);}
    //
    void DetectParticles();
};

#endif // IMAGEPROCESSOR_H
