#include "imageprocessor.h"

//
//
// the image is certain to be bounded by zeros
//
//
// we code a filled pixel with 1
// an edge pixel with 2
//
#define FILL (1)
#define EDGE (2)
//
// this does the fill  a line at a time to reduce recussion. It should only recurse by the number of lines

void ImageProcessor::DoLine(uchar *data, int start)
{
        uchar *p = data + start;
        //
        // determine top and bottom edges
        //
        int x = start % clean.width(); //  start x point
        int b = start; // begin of scan line
        int e = start; // end of scan line
        int y = start / clean.height(); // y position
        //
        // find the begining
        //
        for(int i = x; (i > 0) && (*p > EDGE);  i--, b--, p--)
        {
            area++;
            intensity += *p;
        };
        *p = EDGE;
        //
        // find the end
        p = data + start;
        for(int i = x ;  (i < clean.width()) && (*p > EDGE); i++,e++,p++)
        {
            area++;
            intensity += *p;
        };
        *p = EDGE;
        //
        // b has start, e has end
        edgeList << QPoint(x + (b - start),y) << QPoint(x + (e - start),y);
        //
        // now seek edges top and bottom
        //
        uchar *p = data + b + 1;
        uchar *q = p - clean.width();
        uchar *r = p + clean.width();
        //
        for(int i = b + 1; i < e; i++,p++) *p = FILL; // fill this line
        //
        // now do the top
        //
        for(int i = b + 1; i < e; i++,q++)
        {
            if(!*q)
            {
                *q = EDGE;
                edgeList << QPoint(i,y - 1);
            }
            else if(*q > EDGE)
            {
                DoLine(data, q - data);
            }
        }
        // now look at the bottom
        for(int i = b + 1; i < e; i++,r++)
        {
            if(!*r)
            {
                *r = EDGE;
                edgeList << QPoint(i,y + 1);
            }
            else if(*r > EDGE)
            {
                DoLine(data, r - data);
            }
        }


}

bool ImageProcessor::MeasureParticle(uchar *data, int start)
{
    try
    {
        //
        area = 0;
        intensity = 0;
        DoLine(data,start);
        return true;
    }
    catch(...)
    {

    }
      //
    return false;
}

void ImageProcessor::DetectParticles() // detects particles (circles) and returns the list of hits
{
    stack.clear();
    edgeList.clear();
    points.clear();
    //
    // we start with the clean image
    //
    uchar data[imageSize];
    memcpy(data,clean.bits(),imageSize);
    //
    // set the boundry conditions
   memset(data,0,clean.width());
   memset(data + imageSize - clean.width() - 1,0, clean.width());
   //
    uchar *p = data;
    uchar *q = data + clean.width() - 1;
    //
    for(int i = 0; i < clean.height(); i++, p+= clean.width(), q += clean.width())
    {
        *p = *q = 0;
    }

    // hunt a particle
    p = data + clean.width();
    int nB = imageSize - clean.width() * 2;
    for(int i = 0; i < nB; i++,p++)
    {
        if(*p)
        {
            // found a particle start
            stack.clear();
            edgeList.clear();
            if(MeasureParticle(data, p - data)) // where to start
            {
                sizeParticle(); //
            }
        }
    }
}



void ImageProcessor::sizeParticle()
{
    //
    //  process the edge
    //
    if(edgeList.count())
    {
        //
        // we should now have an edge list
        //
        // from this we can get the particle size and circularity
        // we know the area of the shape in pixels
        // we know the perimeter of the shape (number of edge pixels)
        //
        //  Determine the equivalent cicle area for the same perimeter
        unsigned r = edgeList.count() * 113 / 355 / 2;
        //
        if(r > 1)
        {
            //  get the area
            unsigned a = r * r * 355 / 113;
            double circ = 1.0;
            if(a > 0)
            {
                // Circularity
               circ = (double)pixelCount / (double )a;
            };
            //
            // get the centre of the particle - this is th emean of the x and y values in the edge list
            unsigned sx = 0;
            unsigned sy = 0;
            for(int k = 0; k < edgeList.count(); k++)
            {
                sx += edgeList[k].x();
                sy += edgeList[k].y();
            }
            QPoint pt(sx / edgeList.count(), sy / edgeList.count());
            points << Circle(pt,r,circ,iIntensity);
        }
    }
}


