#ifndef IMAGEFUNCTIONS_H
#define IMAGEFUNCTIONS_H
#include <base.hpp>

struct Circle // we hunt circles
{
    QPoint pt; // centre of circle
    double radius; // measured radius
    double circularity; //  ratio of  sdx / sdy
    unsigned intensity; // integrated intensity
    Circle() : pt(0,0),radius(0),circularity(0),intensity(0){}
    Circle(QPoint p, double r, double c,unsigned i = 0): pt(p), radius(r),circularity(c),intensity(i){}
    Circle(const Circle &c) : pt(c.pt), radius(c.radius),circularity(c.circularity),intensity(c.intensity){}
};

void RemoveBackground(QImage &in, int threshold);
// removes the background such that the given fraction of non-zero pixels remains
typedef QList<Circle> CircleList;
void DetectParticles(QImage &in, CircleList &out); // detects particles (circles) and returns the list of hits
// load an image and convert to 8bit grey scale if necessary
bool LoadImage(QString name, QImage &out);
//
int GuessBackground(QImage &in); // guess the threshold setting
//
#endif // IMAGEFUNCTIONS_H
