#include "ImageFunctions.h"
#include <QVector>

int GuessBackground(QImage &in)
{
    unsigned imageSize =  in.height() *  in.width();
    uchar * p = in.bits ();

    //
    unsigned ph[256];
    memset(ph,0,sizeof(ph));
    for(unsigned i = 0; i < imageSize; i++,p++)
    {
        ph[*p]++;  // get the distribution
    }
    //
    // Aim for 70% of the pixels are background
    //
    int total = 0;
    int fract = imageSize / 3;
    //
    int bl = 3;
    for(int i = 254; i > 0; i--)
    {
        total += ph[i];
        if(total > fract)
        {
            bl = i + 1;
            break;
        };
    }
    unsigned maxP = 0;
    int maxPos = 0;
    p = in.bits();
    for(int i = 0; i < imageSize; i++,p++)
    {
        if(*p > maxP)
        {
            maxP = *p;
            maxPos = i;
        }
    }
    return (bl + (maxP - bl) /2)/2;
}

//
// remove the background.
//
void RemoveBackground(QImage &in, int threshold)
{
     // in this step we remove the baseline from the image
    // do the stats
    // assume grey scale image r = g = b - the image is required to be 8bit grey scale.
    // we can go to the data array directly
    unsigned imageSize =  in.height() *  in.width();
    uchar * p = in.bits ();
    for(unsigned i = 0; i < imageSize; i++,p++)
    {
        if(*p <= threshold) *p = 0;
    }
}

//
// measure a particle by recursive filling
//
static uchar *pData; // the data
static unsigned pixelCount; // number of pixels found = area
static int  iW; // the image width
static int iH; // image height
static int iS; // image size;
static int iEnd;
static unsigned iIntensity;

QList<QPoint> edgeList; // list of edge pixels
#define MAX_PIXEL_COUNT (50000)
//
static void MeasureParticle(int start)
{
    //DBG(start);
    if(pixelCount > MAX_PIXEL_COUNT) throw "Too big";
    uchar *p = pData + start;
    // is this an edge pixel?
    if(!p[-1] || !p[1] || !p[-iW] || !p[iW])
    {
        edgeList << QPoint(start % iW, start / iW); // it is an edge
    }
    //
    // now recurse to the non-zero neighbours - only go down (not up because filling from top to bottom), left , right
     pixelCount++;
     iIntensity += *p;
    *p = 1; // mark as processed
    //
    if(p[-1]  >  1) MeasureParticle(start - 1);
    if(p[1]  > 1) MeasureParticle(start + 1);
    if(p[iW] > 1 ) MeasureParticle(start + iW);
    //
}

// base line must have been removed
void DetectParticles(QImage &in, CircleList &out) // detects particles (circles) and returns the list of hits
{
    out.clear();
    //
    unsigned imageSize =  in.height() *  in.width();
    uchar *pIn = in.bits ();
    uchar data[imageSize]; // working copy of data
    memcpy(data,pIn,imageSize);    // copy the image
    //
    // force boundaries - wrap around leaks etc
    memset(data,0,in.width());
    memset(data + (imageSize - in.width()),0,in.width());
    for(unsigned k = 0; k < imageSize; k+= in.width()) data[k] = 0;
    // we can start working
    uchar *p = data + in.width();
    pData = data;
    iW = in.width();
    iH = in.height();
    iS = imageSize;


    //
    iEnd = imageSize -= iW;
    iEnd -= iW;
    for(unsigned i = iW; i < imageSize; i++,p++)
    {
        if(*p > 1) // non-zero and not filled
        {
            //DBG("Hit at " << i);
            // we require a particle to be non- zero  - we also require > 3 consecutive pixels to make a start
            // otherwise we ignore
            if(p[1] && p[2])
            {
                // worth a punt
                // find the mid point
                uchar *q = p;
                int j;
                for( j = i; (*q > 1); j++,q++) {} // hunt the end
                // determine mid point
                j = (i + j) / 2;
                //  we now fill
                pixelCount = 0; // zero the pixel count
                edgeList.clear();  // clear the edge list
                iIntensity = 0;
                //DBG("Centre at " << j);
                try
                {
                    MeasureParticle(j);
                }
                catch(...)
                {
                    // failed
                    break;
                }
                //
                if(edgeList.count())
                {
                    //
                    // we should now have an edge list
                    //
                    // from this we can get the particle size and circularity
                    // we know the area of the shape in pixels
                    // we know the perimeter of the shape (number of edge pixels)
                    //
                    //  Determine the equivalent cicle area for the same perimeter
                    unsigned r = edgeList.count() * 113 / 355 / 2;
                    //
                    if(r > 1)
                    {
                        //  get the area
                        unsigned a = r * r * 355 / 113;
                        double circ = 1.0;
                        if(a > 0)
                        {
                            // Circularity
                           circ = (double)pixelCount / (double )a;
                        };
                        //
                        // get the centre of the particle - this is th emean of the x and y values in the edge list
                        unsigned sx = 0;
                        unsigned sy = 0;
                        for(int k = 0; k < edgeList.count(); k++)
                        {
                            sx += edgeList[k].x();
                            sy += edgeList[k].y();
                        }
                        QPoint pt(sx / edgeList.count(), sy / edgeList.count());
                        out << Circle(pt,r,circ,iIntensity);
                    }
                }
            }
            else
            {
               *p = 0;
            }
        }
    }
}

static QVector<QRgb>  greyScale;
bool LoadImage(QString name, QImage &out)
{
    // create the grey scale table
    if(!greyScale.count())
    {
        greyScale.resize(256);
        for(int i = 0; i < 256; i++)
        {
            greyScale[i] = qRgb(i,i,i);
        }
    }
    QImage in(name);
    if(!in.isNull())
    {
        if(in.bytesPerLine() != in.width())
        {
             out = in.convertToFormat ( QImage::Format_Indexed8, greyScale);
             // convert to greyscale
        }
        else
        {
            out = in;
        }
        return true;
    }
    return false;
}
