#ifndef XMLVERB_H
#define XMLVERB_H
/*!
 * \file xmlverb.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <Utility/base.hpp>
#include <QHostAddress>
#include <HttpServer/HttpServer_global.h>
// this is a verb for a UDP server
// the verb is expected to be the same as the input document's tag name
class HTTPSERVERSHARED_EXPORT XmlVerb
{
	static QMap<QString,XmlVerb *> Verbs;
	QString Name;
	public:
	XmlVerb(QString name) : Name(name)
	{
		Verbs[name] = this;
		DBG("Add Verb !" << name << "!");
	}
	virtual ~XmlVerb()
	{
		DBG("Remove " << Name);
		Verbs.remove(Name);
	}
	virtual bool Action(QHostAddress /*sender*/, quint16 /*senderPort*/
	,QDomDocument & /* in */, QDomDocument & /*out*/ )
	{
		DBG("base Action");
		return false;
	}
	static bool Do(QHostAddress sender, quint16 senderPort,QDomDocument in, QDomDocument &out);
	// get the verb name
	QString getName() const { return Name;}
};
#endif // XMLVERB_H
