#include "xmlrpcudpverb.h"
#include <Utility/base.hpp>
//
#include <HttpServer/httpserver.h>
#include <HttpServer/HttpServer_global.h>
//
#include <HttpServer/xrmethodcall.h>
#include  <HttpServer/xrmethodresponse.h>
#include "xmlrpcservice.h"

bool  XmlRpcUdpVerb::Action(QHostAddress /*sender*/, quint16 /*senderPort*/
,QDomDocument & in, QDomDocument &out )
{
    XRMethodCall xin;
    XRMethodResponse xout;
    (QDomDocument)xin = in;
        // XML has parsed OK
        if(xin.parseXmlRpc()) // is it valid XMLRPC
        {
                // find the service to call
                DBG("Parsed OK");
                if(XmlRpcServiceHandler::Services.contains(xin.getMethodName()))
                {
                        if(XmlRpcServiceHandler::Services[xin.getMethodName()]->Call(xin,xout,QUrl()))
                        {
                                xout.parseXmlRpc(); // convert to DOM Document
                                out = xout;
                                return true;
                        }
                }
        }
        else
        {
                DBG("Failed to parse");
        }
        return false;
}


