#ifndef XMLRPCSERVICE_H
#define XMLRPCSERVICE_H
//
/*!
 * \file xmlrpcservice.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <Utility/base.hpp>
//
#include <HttpServer/httpserver.h>
#include <HttpServer/HttpServer_global.h>
//
#include <HttpServer/xrmethodcall.h>
#include  <HttpServer/xrmethodresponse.h>
//
// this handles only POST requests where the content type is text/xml
// the service must be registered on something like  /XMLRPC
//
/**
 * @brief
 *
*/
class HTTPSERVERSHARED_EXPORT XmlRpcServiceHandler
{
        QString Name; // service name/**< TODO */

	public:
        static QMap<QString, XmlRpcServiceHandler *> Services;/**< TODO */

        /**
         * @brief
         *
         * @param n
         * @return
        */
        XmlRpcServiceHandler(QString n) : Name(n)
	{
		Services[Name] = this;
	}
        /**
         * @brief
         *
         * @return
        */
        virtual ~XmlRpcServiceHandler()
	{
		Services.take(Name);
	}
	QString getName() const { return Name;}
	// call the method
    virtual bool Call(const XRMethodCall &/*in*/, XRMethodResponse & /*out*/, QUrl /* url*/){ return false;}
};
//
#endif // XMLRPCSERVICE_H
