#ifndef UDPSERVER_H
#define UDPSERVER_H
/*!
 * \file udpserver.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <HttpServer/udpclient.h>
#include <HttpServer/Broadcast.h>
#include <HttpServer/HttpServer_global.h>
// this is a UDP server object - it handles requests by UDP from clients
// a UDP server is also a client
//
// A constraint is that all datagrams are XML - the document element name is the verb
//
// udp servers do not have to be at a fixed address
class HTTPSERVERSHARED_EXPORT UdpServer : public UdpClient
{
	Q_OBJECT
	public:
	UdpServer(int port = 0,   QHostAddress addr = QHostAddress::Any, QUdpSocket::BindMode mode = QUdpSocket::DontShareAddress,QObject *p = 0) ;
	public slots:
	void readPendingDatagrams(); // the event handler
};
//  broadcast servers must be at a fixed shared port - for discovery and system wide notifies
class BroadcastServer : public UdpServer
{
	public:
	BroadcastServer(int port, QObject *p = 0) :
	UdpServer(port, QHostAddress::Any, QUdpSocket::ShareAddress | QUdpSocket::ReuseAddressHint,p)
	{
		SetupBroadcastSocket(getSocket().socketDescriptor());
	}
};
#endif // UDPSERVER_H
