#include "udpserver.h"
#include "xmlverb.h"
// construct
UdpServer::UdpServer(int port,QHostAddress addr, QUdpSocket::BindMode mode, QObject *p)
: UdpClient(port,addr,mode,p)
{
	// make the UDP server event driven
	connect(udp, SIGNAL(readyRead()),this,SLOT(readPendingDatagrams()));
}
void UdpServer::readPendingDatagrams()
{
	DBG("Have Datagram");
	while (getSocket().hasPendingDatagrams())
	{
		QByteArray datagram;
		datagram.resize(getSocket().pendingDatagramSize());
		QHostAddress sender;
		quint16 senderPort;
		getSocket().readDatagram(datagram.data(), datagram.size(), &sender, &senderPort);
		DBG("Data " << datagram.data());
		QDomDocument in;
		QString errMsg;
		int errLine = 0;
		int errCol = 0;
		QDomDocument out;
		if(in.setContent(datagram,&errMsg, &errLine, &errCol))
		{
			DBG(in.toString());
			if(XmlVerb::Do(sender,senderPort,in,out))
			{
				// send the response
				QString e = out.toString();
				// transfer the label
				out.documentElement().setAttribute("TransactionID",in.documentElement().attribute("TransactionID"));
				DBG("Send Response " << e << " host " << sender.toString() << " Port " << senderPort);
				sendDatagram(e.toAscii(),sender,senderPort );
			}
			// otherwise no response - some transactions are one way - eg notifies
		}
		else
		{
			// send error response - malformed XML
			QString e = QString("<ERROR Reason=\"Parse\" Line=%1 Col=%2>%3</ERROR>").arg(errLine).arg(errCol).arg(errMsg);
			sendDatagram(e.toAscii(),sender,senderPort );
			DBG(e);
		}
	}
}
