#ifndef UDPCLIENT_H
#define UDPCLIENT_H
/*!
 * \file udpclient.h
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */

#include <Utility/base.hpp>
#include <QUdpSocket>
#include <QHostAddress>
#include <HttpServer/HttpServer_global.h>
//
// a UDP client object
// sends requests and gets replies form a UDP server
//
#define UDPCLIENT_TIMEOUT (2000)
#define GET_BROADCAST_ADDRESS (QHostAddress::Broadcast)
//
/**
 * @brief
 *
*/
class HTTPSERVERSHARED_EXPORT UdpClient : public QObject
{
	Q_OBJECT
        /**
         * @brief
         *
         * @param QMetaObject::Call
         * @param int
         * @param
         * @return int
        */
        protected:
        QUdpSocket *udp; // the udp socket that can receive broadcasts etc/**< TODO */

	public:
        /**
         * @brief
         *
         * @param 0
         * @param QHostAddress::Any
         * @param QUdpSocket::DontShareAddress
         * @param 0
        */
        UdpClient(int port = 0,  QHostAddress addr = QHostAddress::Any, QUdpSocket::BindMode mode = QUdpSocket::DontShareAddress,QObject *p = 0);
        /**
         * @brief
         *
         * @param hostName
         * @param port
         * @return bool
        */
        bool connectToHost ( const QString & hostName, quint16 port) // establish a virtual connection to a UDP server (receiver)
	{
		getSocket().connectToHost(hostName,port);
		return getSocket().waitForConnected (UDPCLIENT_TIMEOUT);
	}
	int getPort()   { return getSocket().localPort();} // get the local port
	QUdpSocket &getSocket() { return *udp;}
        /**
         * @brief
         *
        */
        void enableReadEvent() // put into event driven mode
	{
		connect(udp, SIGNAL(readyRead()),this,SLOT(readPendingDatagrams()));
	}

	public Q_SLOTS:
	// wait for a response
        /**
         * @brief
         *
         * @param b
         * @param sender
         * @param senderPort
         * @param 5000
         * @return bool
        */
        bool  getDatagram(QByteArray &b, QHostAddress &sender, quint16 &senderPort, int timeout = 5000);
        /**
         * @brief
         *
         * @param b
         * @param host
         * @param port
        */
        void sendDatagram(QByteArray b,QHostAddress host, int port )
	{
		getSocket().writeDatagram ( b,host,port);
	}
    // get the network broadcast address
	void broadcast(QByteArray b, int port) { sendDatagram(b,GET_BROADCAST_ADDRESS,port);}
        /**
         * @brief
         *
        */
        virtual  void readPendingDatagrams()
	{
		while (getSocket().hasPendingDatagrams())
		{
			QByteArray datagram;
			datagram.resize(getSocket().pendingDatagramSize());
			QHostAddress sender;
			quint16 senderPort;
			getSocket().readDatagram(datagram.data(), datagram.size(), &sender, &senderPort);
			DBG(" Have Datagram "  << datagram.data());
			emit haveDatagram(datagram,sender, senderPort); // pass it on
		}
	} // the event handler


	signals:
        /**
         * @brief
         *
         * @param b
         * @param sender
         * @param senderPort
        */
        void haveDatagram(QByteArray b,QHostAddress sender, quint16 senderPort);
};
#endif // UDPCLIENT_H
