#include "udpclient.h"
UdpClient::UdpClient(int port, QHostAddress addr, QUdpSocket::BindMode mode,  QObject *p) : QObject(p)
{
	udp = new QUdpSocket(this);
        DBG("Port" << port << " address " << addr.toString())
	if(! udp->bind(addr,port,mode))
	{
		qWarning("Failed to bind UDP socket");
	};
}
// synchronous read - avoid in main thread as it blocks
bool  UdpClient::getDatagram(QByteArray &b, QHostAddress &sender, quint16 &senderPort, int timeout)
{
	QTime t;
	t.start();
	while (!udp->hasPendingDatagrams())
	{
		if(t.elapsed() > timeout) return false;
	}
	b.resize(udp->pendingDatagramSize());
	udp->readDatagram(b.data(), b.size(),&sender, &senderPort);
	return true;
}

