#ifndef STATICWEBSERVICE_H
#define STATICWEBSERVICE_H
/*!
 * \file staticwebservice
 *
 * \author B. J. Hill
 * \date __DATE__
 *  License:  GNU LESSER GENERAL PUBLIC LICENSE 2.1
 *  (c)  Micro Research Limited 2010 -
 *  $Id$
 */
#include <Utility/base.hpp>
#include <Utility/file.h>
#include <HttpServer/httpserver.h>
#include <HttpServer/HttpServer_global.h>
#include <HttpServer/xmlrpcservice.h>
/**
 * @brief
 *
*/
class  HTTPSERVERSHARED_EXPORT StaticWebService
: public QxtAbstractWebService
{
	public:
        /**
         * @brief
         *
         * @param manager
         * @param 0
        */
        StaticWebService(QxtAbstractWebSessionManager * manager , QObject * parent = 0);
        /**
         * @brief
         *
         * @param event
        */
        void pageRequestedEvent ( QxtWebRequestEvent *event ); // a page has been requested

    /**
     * @brief
     *
     * @param event
     * @param error
     * @param message
     * @return QxtWebPageEvent *
    */
    QxtWebPageEvent *errorEvent(QxtWebRequestEvent *event , int error, QString message)
    {
        QByteArray res;
        QxtWebPageEvent *e  = new QxtWebPageEvent ( event->sessionID ,event->requestID , res);
        e->status  = error;
        e->statusMessage = message.toAscii();
        return e;
    };
        /**
         * @brief
         *
         * @param event
         * @param error
         * @param message
        */
        void postError( QxtWebRequestEvent *event , int error, QString message) // post an error
	{
        postEvent(errorEvent(event,error,message) );
	}
	virtual bool checkSecurity(QxtWebRequestEvent * /*event*/) { return true;}
	// translate a filename - by default chroot to the application' s directory
        /**
         * @brief
         *
         * @param f
         * @return QString
        */
        virtual QString getFileName(QString f)
	{
                 File fl("Data",f);
                return fl.fileName();
	}
	//
	// these handle each of the possible HTTP calls
        /**
         * @brief
         *
         * @param event
         * @return QxtWebPageEvent *
        */
        virtual QxtWebPageEvent * get(QxtWebRequestEvent *event);
        /**
         * @brief
         *
         * @param event
         * @return QxtWebPageEvent *
        */
        virtual QxtWebPageEvent * put(QxtWebRequestEvent *event);
        /**
         * @brief
         *
         * @param event
         * @return QxtWebPageEvent *
        */
        virtual QxtWebPageEvent * head(QxtWebRequestEvent *event);
        /**
         * @brief
         *
         * @param event
         * @return QxtWebPageEvent *
        */
        virtual QxtWebPageEvent * post(QxtWebRequestEvent *event);
        /**
         * @brief
         *
         * @param event
         * @return QxtWebPageEvent *
        */
        virtual QxtWebPageEvent * del(QxtWebRequestEvent *event);
	//
	// these interface to the file system - however it is implemented
        /**
         * @brief
         *
         * @param d
         * @param url
         * @return bool
        */
        virtual bool getData(QByteArray &d, QUrl url);
    /**
     * @brief
     *
     * @param d
     * @param url
     * @return bool
    */
    virtual bool putData(QByteArray d, QUrl url);
    /**
     * @brief
     *
     * @param url
     * @return bool
    */
    virtual bool delData(QUrl url);
    //
    /**
     * @brief
     *
     * @return QByteArray
    */
    virtual QByteArray getIndex(); // get the index page
    //
    // list, make and remove directory
    //
    /**
     * @brief
     *
     * @param event
     * @return QxtWebPageEvent *
    */
    virtual QxtWebPageEvent * ls(QxtWebRequestEvent *event);
    /**
     * @brief
     *
     * @param event
     * @return QxtWebPageEvent *
    */
    virtual QxtWebPageEvent * mkdir(QxtWebRequestEvent *event);
    /**
     * @brief
     *
     * @param event
     * @return QxtWebPageEvent *
    */
    virtual QxtWebPageEvent * rmdir(QxtWebRequestEvent *event);

};
#endif // STATICWEBSERVICE_H
