#include "staticwebservice.h"
// This is a small HTTP server that also does XMLRPC
// we get and put whole data blocks - so large files are a possible problem
// Should work for most configuration SCADA type applications
// the get an put methods will have to be overloaded to handle large files
//
// construct the service handler
//
StaticWebService::StaticWebService(QxtAbstractWebSessionManager * manager , QObject * parent ):
QxtAbstractWebService(manager,parent)
{
}
//
// this is invoked when none of the other service handlers are called - this is a file server.
// The root is in the application's Data directory
// eventually add security to all requests
//
// we do clever requests using the services directory
//
void StaticWebService::pageRequestedEvent ( QxtWebRequestEvent *event )
{
	//
	QxtWebPageEvent *e = 0;
	DBG(event->method); // say what the method is
	// we are interested in GET,  PUT,  POST,  and DELETE
	if(event->method == "GET")
	{
		e =  get(event);
	}
	else if(event->method == "HEAD")
	{
        e =  head(event);
	}
	else if (event->method == "PUT")
	{
		e = put(event);
	}
	else if (event->method == "POST")
	{
		e = post(event);
	}
	else if (event->method == "DELETE")
	{
		e = del(event);
	}
	// return the result
	if(e)
	{
		postEvent(e);
	}
	else
	{
		postError(event,501, "Not Implemented");
	}
	//
}

QByteArray StaticWebService::getIndex() // get the index page - by default index.html
{
    QByteArray res;
    QString file = getFileName("index.html"); // get the full path to the file
    QFile F(file);
    if(F.open(QIODevice::ReadOnly))
    {
        res =  F.readAll();
    }
    return res;
}

// get  a page
QxtWebPageEvent * StaticWebService::get( QxtWebRequestEvent *event)
{
	QxtWebPageEvent *res = 0;
	QByteArray b;
    if(event->url.path().isEmpty())
    {
        // get the root HTML page
        b = getIndex();
        res  = new QxtWebPageEvent ( event->sessionID ,event->requestID , b);
    }
    else if(getData(b,event->url)) // get the full path to the file
	{
		res  = new QxtWebPageEvent ( event->sessionID ,event->requestID , b);
	}
	else
	{
		DBG("Failed to get file");
        res = errorEvent(event,404,"Not Found");
	}
	return res;
}
// put a file
QxtWebPageEvent * StaticWebService::put(QxtWebRequestEvent *event)
{
	QxtWebPageEvent *res = 0;
	if(checkSecurity(event))
	{
		if(!event->content.isNull())
		{
			event->content->waitForAllContent ( ); // block for read
			event->content->open(QIODevice::ReadOnly); // open it
			QByteArray d = event->content->readAll();
			event->content->close();
			if(putData(d,event->url ))
			{
				QByteArray r;
				res  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,r);
			}
			else
			{
                res = errorEvent(event,403, "Forbidden");
			}
		}
		else
		{
            res = errorEvent(event,403, "Forbidden");
		}
	}
	else
	{
        res = errorEvent(event,401, "Unauthorised");
	}
	return res;
}
// get the head information
QxtWebPageEvent * StaticWebService::head(QxtWebRequestEvent *event)
{
	QxtWebPageEvent *res = 0;
    QString file = getFileName(event->url.path()); // get the full path to the file
	QFileInfo f(file);
	if(f.exists())
	{
		QByteArray r;
		res  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,r);
	}
	else
	{
        res = errorEvent(event,404,"Not Found");
	}
	return res;
}
// do a post - XML RPC by default
QxtWebPageEvent * StaticWebService::post(QxtWebRequestEvent *event)
{
	QxtWebPageEvent *res = 0;
    //
    QUrl u = event->url;
    DBG("StaticWebService::post " << u.toString())
    if(u.hasQuery()) //  we do ls, mkdir,rmdir and del
    {
        if(u.hasQueryItem("ls"))
        {
            res = ls(event); // get a listing
        }
        else if(u.hasQueryItem("mkdir")) // create a directory - could be database table or XML element
        {
            res = mkdir(event);
        }
        else if(u.hasQueryItem("rmdir")) // remove directory
        {
            res = rmdir(event);
        }
        else if(u.hasQueryItem("del")) //  delete a file (DELETE not supported by QNetworkRequest
        {
            res = del(event);
        }

    }
    else 	if(event->contentType == "text/xml")
	{
		// now get the content into an XML document
		//
		event->content->waitForAllContent ( ); // block for read
		event->content->open(QIODevice::ReadOnly); // open it
		XRMethodCall d;
		QByteArray b =  event->content->readAll();
                DBG("XMLRPC Request\n" << (const char *)b);
		event->content->close();
		if(d.setContent(b))
		{
			// XML has parsed OK
			if(d.parseXmlRpc()) // is it valid XMLRPC
			{
				// find the service to call
				DBG("Parsed OK");
				if(XmlRpcServiceHandler::Services.contains(d.getMethodName()))
				{
					XRMethodResponse r;
					DBG("Call Method " << d.getMethodName());
					if(XmlRpcServiceHandler::Services[d.getMethodName()]->Call(d,r,event->url))
					{
						r.parseXmlRpc(); // convert to DOM Document
						res  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,r.toString().toAscii());
					}
				}
			}
			else
			{
				DBG("Failed to parse");
			}
		}
	}
	return res;
}
// delete a file
QxtWebPageEvent * StaticWebService::del(QxtWebRequestEvent *event)
{
	QxtWebPageEvent *res = 0;
	if(checkSecurity(event))
	{
		if(delData(event->url))
		{
            res  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,QByteArray());
		}
		else
		{
            res = errorEvent(event,401, "Unauthorised");
		}
	}
	else
	{
        res = errorEvent(event,401, "Unauthorised");
	}
	return res;
}
//
// virtualise data get and put
//
bool StaticWebService::getData(QByteArray &d, QUrl url)
{
	QString file = getFileName(url.path()); // get the full path to the file
	QFile F(file);
	if(F.open(QIODevice::ReadOnly))
	{
		d = F.readAll();
		return true;
	}
	return false;
}
bool StaticWebService::putData(QByteArray d, QUrl url)
{
	QString file = getFileName(url.path()); // get the full path to the file
	QFile F(file);
	if(F.open(QIODevice::WriteOnly))
	{
		F.write(d);
		return true;
	}
	return false;
}

// delete a file
bool StaticWebService::delData(QUrl url)
{
	QString file = getFileName(url.path()); // get the full path to the file
	QFile F(file);
	return F.remove();
}

QxtWebPageEvent * StaticWebService::ls(QxtWebRequestEvent *event)
{
    QUrl u = event->url;
    QString nf = u.queryItemValue ( "ls");
    if(nf.isEmpty()) nf = "*";
    QDir d(u.path(),nf);
    //
    // now generate the list as XML - can walk with XMLtraversal
    QStringList l;
    l << "<DIR>";
    //
    // now list the files and directories
    //
    QFileInfoList ld =  d.entryInfoList ();
    for(int i = 0; i < ld.count(); i++)
    {
      l << QString("<ITEM%1 IsFile=\"%2\" >%3</ITEM%4>")
              .arg(i)
              .arg(ld[i].isFile()?1:0)
              .arg(ld[i].fileName())
              .arg(i);
    };
    l << "</DIR>";
    QString s = l.join("\n");
    return  new QxtWebPageEvent ( event->sessionID ,event->requestID ,s.toAscii());
}

QxtWebPageEvent * StaticWebService::mkdir(QxtWebRequestEvent *event)
{
    QUrl u = event->url;
    QDir d;
    // create the path
    if(d. mkpath( u.path()))
    {
        return new QxtWebPageEvent ( event->sessionID ,event->requestID ,QByteArray());
    }
    return errorEvent(event,403, "Forbidden");
}

QxtWebPageEvent * StaticWebService::rmdir(QxtWebRequestEvent *event)
{
    QUrl u = event->url;
    QDir d;
    // create the path
    if(d.rmdir( u.path()))
    {
        return new QxtWebPageEvent ( event->sessionID ,event->requestID ,QByteArray());
    }
    return errorEvent(event,403, "Forbidden"); // failed
}


