#include "multicatreceiver.h"
#  include <sys/types.h>
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <arpa/inet.h>
# include <Utility/Logging.h>
#include <stdio.h>
// this socket recieves  multi cast packets
MulticastReceiver::MulticastReceiver(QString g, int port, QObject *parent) :
    QUdpSocket(parent),_group(g)
{
    if(bind(QHostAddress::Any,port, ReuseAddressHint)) // socket is set up
    {
        /* construct an IGMP join request structure */
        struct ip_mreq mc_req;
        //
        mc_req.imr_multiaddr.s_addr = inet_addr((const char *)g.toAscii());
        mc_req.imr_interface.s_addr = htonl(INADDR_ANY);
        if ((setsockopt(socketDescriptor(), IPPROTO_IP, IP_ADD_MEMBERSHIP,
             (void*) &mc_req, sizeof(mc_req))) <0)
        {
          perror("setsockopt() failed");
        }
    }
}

MulticastReceiver::~MulticastReceiver()
{
    struct ip_mreq mc_req;
    mc_req.imr_multiaddr.s_addr = inet_addr((const char *)_group.toAscii());
    mc_req.imr_interface.s_addr = htonl(INADDR_ANY);
    if ((setsockopt(socketDescriptor(), IPPROTO_IP, IP_DROP_MEMBERSHIP,
         (void*) &mc_req, sizeof(mc_req))) < 0) {
      perror("setsockopt() failed");
    }
}
