#include "multicastsender.h"
#  include <sys/types.h>
#  include <sys/socket.h>
#  include <netinet/in.h>
#  include <arpa/inet.h>
# include <Utility/Logging.h>
#include <stdio.h>
// just send to the multi cast address - quite how it will work outside a LAN I do not know
// setting ttl to 8 will mean it will route locally
//
/**
 * @brief
 *
 * @param ttl
 * @param p
 * @return
*/
MulticastSender::MulticastSender( unsigned ttl, QObject *p ) : QUdpSocket(p)
{
    if(bind())
    {
         unsigned char mc_ttl= ttl; // set the TTL
        if ((setsockopt(socketDescriptor(), IPPROTO_IP, IP_MULTICAST_TTL,
                        (void*) &mc_ttl, sizeof(mc_ttl))) < 0) { perror("setsockopt() failed");}
    }
}

/**
 * @brief
 *
 * @param ttl
 * @return bool
*/
bool MulticastSender::setTTL(int ttl)
{
    unsigned char mc_ttl= ttl; // set the TTL
   if ((setsockopt(socketDescriptor(), IPPROTO_IP, IP_MULTICAST_TTL,
                   (void*) &mc_ttl, sizeof(mc_ttl))) < 0)
    {
       perror("setsockopt() failed");
       return false;
   }
    return true;
}
