#include "httpclient.h"
#include <QxtSignalWaiter>
#include <Utility/xmltraversal.h>
//
// construct
//
HttpClient::HttpClient(QObject *p) : QNetworkAccessManager(p)
{
}
// call an XML RPC proceedure - does POST
QNetworkReply * HttpClient::xmlRpcCall(QUrl host, QString method, QList<QVariant> args)
{
	XRMethodCall r(method,  args);
	r.parseXmlRpc();
	QByteArray b = r.toString().toAscii();
	QNetworkRequest rq(host);
	rq.setHeader ( QNetworkRequest::ContentTypeHeader,QVariant("text/xml") );
	return post(rq,b);
}
//
// These are blocking actions  - the reply object will be marked deleteLater
// - so must be used immediately
//
// get data
//
QNetworkReply * HttpClient::getBlock(QUrl host, int to) // blocking get
{
	bool res = false;
	QNetworkRequest rq(host);
	QNetworkReply *r = get(rq);
	if(r)
	{
		QxtSignalWaiter waiter(r, SIGNAL(finished())); // blocking wait
		res =  waiter.wait(to);
		r->deleteLater(); // mark for delete
	}
	return res?r:0; // return object if success, null if timeout
}
// put data
QNetworkReply * HttpClient::putBlock(QUrl host, QByteArray data, int to) // blocking put
{
	bool res = false;
	QNetworkRequest rq(host);
	QNetworkReply *r = put(rq,data);
	if(r)
	{
		QxtSignalWaiter waiter(r, SIGNAL(finished()));
		res = waiter.wait(to);
		r->deleteLater();
	}
	return res?r:0;
}
// do a post
QNetworkReply * HttpClient::postBlock(QUrl host, QByteArray data, int to) // blocking post
{
	bool res = false;
	QNetworkRequest rq(host);
	QNetworkReply *r = post(rq,data);
	if(r)
	{
		QxtSignalWaiter waiter(r, SIGNAL(finished()));
		res = waiter.wait(to);
		r->deleteLater();
	}
	return res?r:0;
}
// blocking RPC call
bool HttpClient::xmlRpcCallBlock(QUrl host, const XRMethodCall &in,
XRMethodResponse & out, int to)
{
	QByteArray b = in.toString().toAscii();
	QNetworkRequest rq(host);
	rq.setHeader ( QNetworkRequest::ContentTypeHeader,QVariant("text/xml") );
	QNetworkReply *r =  post(rq,b);
	if(r)
	{
		QxtSignalWaiter waiter(r, SIGNAL(finished()));
		bool res = waiter.wait(to);
		r->deleteLater();
		//
		out.setContent(r);
		out.parseXmlRpc(); // set the variables
		return res;
	};
	return false;
}



