#include "ItemService.h"
#include <base.hpp>
#include <QxtWebPageEvent>
//
// to do generalise this for any object type eg classes, processes and states
//
ItemService::ItemService (QString dp, QString t, QxtAbstractWebSessionManager * manager , QObject * parent  ) :
StaticWebService(manager,parent),dbName(dp),tbName(t)
{
	QString p = QString("%1%2").arg(qApp->applicationDirPath() ).arg(dp);
	QDir d(p);
	if(!d.exists())   d.mkpath(p);
	if(!QSqlDatabase::contains(t))
	{
		QSqlDatabase::addDatabase("QSQLITE",t);
	}
	db =  QSqlDatabase::database (t,false);
	db.setDatabaseName(QString("%1/%2" ).arg(p).arg(t)); // SQLITE the database name is the path to the data file
	if(db.open())
	{
		//  things can be of any size
		// I_NAME is the object name
		// I_Updated is the timestamp of the last update
		// I_Data is the xml specifying the object - stored as a BLOB - could be anything
		QString cmd =
		QString("CREATE TABLE IF NOT EXISTS %1 (I_Name TEXT PRIMARY KEY ASC, I_Updated TEXT,  I_Data TEXT);")
		.arg(tbName);
		db.exec(cmd); // create the items table if not present
		//
		// can create a backup table too - TODO
		//
	}
	else
	{
		qWarning("Failed to open database");
	}
}
// the
// perform the required operation
void ItemService::pageRequestedEvent ( QxtWebRequestEvent * event)
{
	QByteArray res; // what we return - default empty
	QxtWebPageEvent *e = 0;
	DBG(event->method); // say what the method is
	//
	if(db.isOpen())
	{
		// we are interested in GET,  PUT,  POST,  and DELETE
		//
		// get the item name from the URL
		//
		QString name = event->url.path();
		//
		if(event->method == "GET")
		{
			if(name.isEmpty())
			{
				// list the items
				QString cmd = "SELECT I_Name FROM ITEMS;";
				QSqlQuery q(cmd,db);
				//
				// now iterate the items
				//
				QStringList l;
				while (q.next())
				{
					l <<  q.value(0).toString();
				}
				res = l.join("\n").toAscii();
				e  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,res);
			}
			else
			{
				QString cmd = QString("SELECT I_Data FROM %1 WHERE I_Name='%2';").arg(tbName).arg(name);
				QSqlQuery q(cmd,db);
				if(q.size() > 0)
				{
					e  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,q.value(0).toByteArray());
				}
				else
				{
					postError(event,404,"Not Found");
					return;
				}
			}
		}
		else if(event->method == "HEAD")
		{
			e  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,res);
		}
		else if (event->method == "PUT")
		{
			if(checkSecurity(event))
			{
				if(!event->content.isNull() )
				{
					event->content->waitForAllContent(); // block for read
					event->content->open(QIODevice::ReadOnly); // open it
					//
					QByteArray b = event->content->readAll();
					//
					QSqlQuery q(db);
					//  prepare these on entry to speed things up
					q.prepare(QString("INSERT OR REPLACE INTO %1 (I_Name,I_Updated,I_Data) VALUES (?,?,?);")
					.arg(tbName));
					q.addBindValue(name);
					q.addBindValue(QDateTime::currentDateTime().toString(Qt::ISODate));
					q.addBindValue(b);
					q.exec();
					//
					// duplicate to backup - TODO
					//
					event->content->close();
				};
				e  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,res);
			}
			else
			{
				postError(event,401, "Unauthorised");
				return;
			}
		}
		else if (event->method == "POST")
		{
			// crack any commands
		}
		else if (event->method == "DELETE")
		{
			if(checkSecurity(event))
			{
				QString cmd = QString("DELETE FROM %1 WHERE I_Name='%2';").arg(tbName).arg(name);
				db.exec(); // delete the item
				e  = new QxtWebPageEvent ( event->sessionID ,event->requestID ,res);
			}
			else
			{
				postError(event,401, "Unauthorised");
				return;
			}
		}
	}
	// return the result
	if(e)
	{
		postEvent(e);
	}
	else
	{
		postError(event,501, "Not Implemented");
	}
	//
}
