#include <QtCore/QCoreApplication>
// basic stuff
#include <Utility/base.hpp>
// file access
#include <Utility/file.h>
// XML traversal
#include <Utility/xmltraversal.h>
// UDP server
#include <HttpServer/xmlverb.h>
//
// XML RPC
#include <HttpServer/xmlrpcservice.h>
//
#include <QHostInfo>
// The UDP server class
#include <HttpServer/udpserver.h>
// Web serivce
#include <HttpServer/httpserver.h>
#include <HttpServer/staticwebservice.h>
//
// an example XML handler - can be a response to a broadcast to discover servers
// Look in ExampleClient for example of calling
//
class DiscoveryVerb : public XmlVerb
{
        public:
    /**
    * @brief  Constructs the handler
    * @fn DiscoveryVerb
    */
     DiscoveryVerb(): XmlVerb("Discovery"){}
// handle the request

    /**
    * @brief
    *
    * @fn Action
    * @param sender     QHostAddress of the message sender
    * @param senderPort     The port the message was sent from,hence reply should be sent to
    * @param in the QDomDocument of the message from the sender
    * @param out the QDomDocument to be sent back to the sender
    * @return bool true if the request succeeds
    */
                bool Action(QHostAddress /*sender*/, quint16 /*senderPort*/
                        ,QDomDocument & /* in */, QDomDocument & /*out*/ );
};

bool DiscoveryVerb::Action(QHostAddress /*sender*/, quint16 /*senderPort*/,QDomDocument  &/*in */, QDomDocument & out )
{
        qDebug() << "Discovery Action Called";
        XMLTraversal x;
        x.initialise("Configuration");
        x.cd("/Configuration");
        XmlSet(x,"HostName",QHostInfo::localHostName());
        out = x.document();
        return true;
}
// Register the service
static DiscoveryVerb Verb;
//
// Example of XMLRPC service
// Adds two numbers and returns the result - fails if wrong number parameters
//
class AddNumbersRequest : public XmlRpcServiceHandler
{
        public:
                AddNumbersRequest() : XmlRpcServiceHandler("AddNumbersRequest") {}
                bool Call(const XRMethodCall &/*in*/, XRMethodResponse & /*out*/, QUrl);
};
bool AddNumbersRequest::Call(const XRMethodCall &in, XRMethodResponse & out, QUrl )
{
    if(in.getParams().count() == 2)
    {
        double r = in.getParams()[0].toDouble() + in.getParams()[1].toDouble();
        QVariant v;
        v = QVariant(r);
        XRMethodResponse res(v);
        out = res;
    }
    else
    {
        out = XRMethodResponse(-1,"Incorrect Parameter Count");
     }
    return true;
}
//Register service
static AddNumbersRequest _addNumbersRequest;
//
// Example on how to use the HttpServer
//
int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    // HTTP server looks in Data subdirectory for files
    // Change to suit
    File::setRoot("/usr/local/Task");
    QDir d(File::root());
    d.mkdir("Data"); // make sure the directory exists
//
// Put an index.html file into the Data subdirectory  - and load it from Firefox with
// http://localhost:4040
//
// set up the UDP server - uses same port number as HTTP server
    UdpServer udpServer(4040);
// create the HTTP server
    HttpServer web( 4040);
//
    // file access and XMLRPC routing
    StaticWebService *fileServer  = new StaticWebService(&web,&web);
    web.setStaticContentService (fileServer);
//
    qDebug("Start Web");
    // start the web
    web.start();
    return a.exec();
}
