#ifndef TESTCLIENT_H
#define TESTCLIENT_H
//
// test harness for HttpServer
// runs tests for UDP server and XMLRPC
//
#include <Utility/base.hpp>
#include <Utility/xmltraversal.h>
// the HTTP client interface
#include <HttpServer/httpclient.h>
// the UDP client interface
#include <HttpServer/udpclient.h>

//
class TestClient : public QObject
{
    Q_OBJECT
    // timers for tests
    QTimer udpTimer;
    QTimer rpcTimer;
    //
    // interfaces
    UdpClient udp;
    HttpClient http;
    //
    double value0;
    double value1;
public:
    explicit TestClient(QObject *parent = 0);

signals:

public slots:
    void UdpRequest();
    void XmlRpcTest();
};

#endif // TESTCLIENT_H
