#include "testclient.h"
#include <HttpServer/httpclient.h>
#include <HttpServer/udpclient.h>
//
// this shows how to call a UDP and XMLRPC server
// in use you encapsulate each call in a function
//

TestClient::TestClient(QObject *parent) :
    QObject(parent),
    value0(0),
    value1(0)
{
    // start tests
    connect(&udpTimer,SIGNAL(timeout()),this,SLOT(UdpRequest()));
    connect(&rpcTimer,SIGNAL(timeout()),this,SLOT(XmlRpcTest()));
    udpTimer.start(5000);
    rpcTimer.start(5000);
    qDebug() << "Test Timers Started";
}

void TestClient::UdpRequest()
{
    // server is on local host
    qDebug() << "Sending UDP Request";
    udp.sendDatagram("<Discovery/>",QHostAddress::LocalHost,4040);
    //
    // get the replay
    QByteArray reply;
    QHostAddress sender;
    quint16 senderPort;
    //
    if(udp.getDatagram(reply,sender,senderPort))
    {
        qDebug() <<"Reply " << reply << " Sender "  << sender.toString() << " Port " << senderPort;
    }
    else
    {
        qDebug("No Response - Is ExampleServer Running?");
    }
}

void TestClient::XmlRpcTest()
{
    // bump the values
    value0 += 0.5;
    value1 += 0.3;
    //
    qDebug() << "value0 = " << value0 << " value1 = " << value1;
    // make the XMLRPC call
    //host to call
    QUrl host = QUrl("http://localhost:4040") ;
    //
    // Push the arguments
    //
    QList<QVariant> l;
     l  << value0;
     l  << value1;
    // set the call frame
    XRMethodCall in("AddNumbersRequest",l);
    XRMethodResponse o;
    // call
    bool res =  http.xmlRpcCallBlock(host,in,o,1000);
    //
    if(res)
    {
        // pop result
        qDebug() << "Result = "  <<  o.getResponse().toDouble();
    }
    else
    {
        qDebug() << "Call Failed - ExampleServer Running?";
    }
}
