#include "Broadcast.h"
// set up a broadcast socket
#include <QtGlobal>
#ifdef Q_OS_UNIX
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <linux/if.h>
#include <sys/ioctl.h>
#endif
#ifdef Q_OS_WIN32
#include <winsock2.h>
#endif
//
// set the options on a broadcast socket so it can broadcast
bool  SetupBroadcastSocket(int sd)
{
#ifdef Q_OS_UNIX
	const int on = 1;
	if ( setsockopt(sd, SOL_SOCKET, SO_BROADCAST, &on, sizeof(on)) != 0 )
	{
		return false;
	};
#endif
#ifdef Q_OS_WIN32
	bool on = 1;
	if ( setsockopt((SOCKET)sd, SOL_SOCKET, SO_BROADCAST, (const char *)&on, sizeof(on)) != 0 )
	{
		return false;
	};
#endif
	return true;
};
